/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.operation;

import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSession;
import org.camunda.bpm.engine.cassandra.provider.ProcessInstanceBatch;
import org.camunda.bpm.engine.cassandra.provider.operation.CompositeEntityLoader;
import org.camunda.bpm.engine.cassandra.provider.operation.LoadedCompositeEntity;
import org.camunda.bpm.engine.cassandra.provider.serializer.CassandraSerializer;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;

public class ProcessInstanceLoader
implements CompositeEntityLoader {
    private static final Logger LOG = Logger.getLogger(ProcessInstanceLoader.class.getName());
    public static final String NAME = "process-instance-compostite";
    public static final String EVENT_SUBSCRIPTIONS = "event_subscriptions";
    public static final String EXECUTIONS = "executions";
    public static final String VARIABLES = "variables";

    @Override
    public LoadedCompositeEntity getEntityById(CassandraPersistenceSession session, String id) {
        LoadedCompositeEntity loadedProcessInstance = new LoadedCompositeEntity();
        Session s = session.getSession();
        Row row = s.execute((Statement)QueryBuilder.select().all().from("cam_proc_inst").where(QueryBuilder.eq((String)"id", (Object)id))).one();
        if (row == null) {
            return null;
        }
        int version = row.getInt("version");
        String businessKey = row.getString("business_key");
        CassandraSerializer<ExecutionEntity> executionSerializer = CassandraPersistenceSession.getSerializer(ExecutionEntity.class);
        CassandraSerializer<EventSubscriptionEntity> eventSubscriptionSerializer = CassandraPersistenceSession.getSerializer(EventSubscriptionEntity.class);
        CassandraSerializer<VariableInstanceEntity> variableSerializer = CassandraPersistenceSession.getSerializer(VariableInstanceEntity.class);
        Map executionsMap = row.getMap(EXECUTIONS, String.class, UDTValue.class);
        HashMap<String, ExecutionEntity> executions = new HashMap<String, ExecutionEntity>();
        for (UDTValue serializedExecution : executionsMap.values()) {
            ExecutionEntity executionEntity = executionSerializer.read((GettableData)serializedExecution);
            executions.put(executionEntity.getId(), executionEntity);
            if (!executionEntity.isProcessInstanceExecution()) continue;
            loadedProcessInstance.setMainEntity((DbEntity)executionEntity);
        }
        loadedProcessInstance.put(EXECUTIONS, executions);
        Map eventSubscriptionsMap = row.getMap(EVENT_SUBSCRIPTIONS, String.class, UDTValue.class);
        HashMap<String, EventSubscriptionEntity> eventSubscriptions = new HashMap<String, EventSubscriptionEntity>();
        for (UDTValue serializedEventSubscription : eventSubscriptionsMap.values()) {
            EventSubscriptionEntity eventSubscriptionEntity = eventSubscriptionSerializer.read((GettableData)serializedEventSubscription);
            eventSubscriptions.put(eventSubscriptionEntity.getId(), eventSubscriptionEntity);
        }
        loadedProcessInstance.put(EVENT_SUBSCRIPTIONS, eventSubscriptions);
        Map variablesMap = row.getMap(VARIABLES, String.class, UDTValue.class);
        HashMap<String, VariableInstanceEntity> variables = new HashMap<String, VariableInstanceEntity>();
        for (UDTValue serializedVariable : variablesMap.values()) {
            VariableInstanceEntity variableEntity = variableSerializer.read((GettableData)serializedVariable);
            variables.put(variableEntity.getId(), variableEntity);
        }
        loadedProcessInstance.put(VARIABLES, variables);
        this.reconstructEntityTree(loadedProcessInstance);
        ExecutionEntity processInstance = (ExecutionEntity)loadedProcessInstance.getPrimaryEntity();
        processInstance.setRevision(version);
        processInstance.setBusinessKey(businessKey);
        ProcessInstanceBatch batch = new ProcessInstanceBatch((ExecutionEntity)loadedProcessInstance.getPrimaryEntity());
        LOG.fine("Loaded process instance, id=" + processInstance.getId() + ", version=" + processInstance.getRevision());
        session.addLockedBatch(loadedProcessInstance.getPrimaryEntity().getId(), batch);
        return loadedProcessInstance;
    }

    protected void reconstructEntityTree(LoadedCompositeEntity compositeEntity) {
        ExecutionEntity processInstance = (ExecutionEntity)compositeEntity.getPrimaryEntity();
        Map<String, ? extends DbEntity> executions = compositeEntity.getEmbeddedEntities().get(EXECUTIONS);
        Map<String, ? extends DbEntity> eventSubscriptions = compositeEntity.getEmbeddedEntities().get(EVENT_SUBSCRIPTIONS);
        Map<String, ? extends DbEntity> variables = compositeEntity.getEmbeddedEntities().get(VARIABLES);
        processInstance.restoreProcessInstance(executions.values(), eventSubscriptions.values(), variables.values());
    }
}

