/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSession;
import org.camunda.bpm.engine.cassandra.provider.indexes.IndexHandler;
import org.camunda.bpm.engine.cassandra.provider.indexes.JobsByConfigurationIndex;
import org.camunda.bpm.engine.cassandra.provider.operation.JobOperations;
import org.camunda.bpm.engine.cassandra.provider.query.SelectListQueryHandler;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;

public class SelectJobsByConfiguration
implements SelectListQueryHandler<JobEntity, ListQueryParameterObject> {
    @Override
    public List<JobEntity> executeQuery(CassandraPersistenceSession session, ListQueryParameterObject query) {
        Map params = (Map)query.getParameter();
        String config = (String)params.get("handlerConfiguration");
        String followUpConfig = (String)params.get("handlerConfigurationWithFollowUpJobCreatedProperty");
        String type = (String)params.get("handlerType");
        IndexHandler<JobEntity> index = JobOperations.getIndexHandler(JobsByConfigurationIndex.class);
        List<String> keys = index.getValues(null, session, type, config);
        keys.addAll(index.getValues(null, session, type, followUpConfig));
        ArrayList<JobEntity> result = new ArrayList<JobEntity>();
        for (String keyStr : keys) {
            JobEntity job = session.selectById(JobEntity.class, keyStr);
            if (job == null) continue;
            result.add(job);
        }
        return result;
    }
}

