/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.query;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.cassandra.cfg.CassandraProcessEngineConfiguration;
import org.camunda.bpm.engine.cassandra.provider.CassandraPersistenceSession;
import org.camunda.bpm.engine.cassandra.provider.indexes.IndexUtils;
import org.camunda.bpm.engine.cassandra.provider.query.SelectListQueryHandler;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;

public class SelectNextJobsToExecute
implements SelectListQueryHandler<JobEntity, ListQueryParameterObject> {
    private static final String SELECT = "SELECT id FROM cam_job_idx WHERE shard_id = ? AND is_locked = ? AND sort_time < ? LIMIT ?;";
    private static final String SELECT_ACTIVE = "SELECT id FROM cam_job_idx WHERE shard_id = ? AND is_locked = ? LIMIT ?;";
    private static PreparedStatement selectActiveStatement = null;
    private static PreparedStatement selectStatement = null;
    protected static int shardSizeMillis;
    protected static int shardInitNumber;
    protected static List<Long> activeShards;
    protected static List<Long> activeLockedShards;

    public static void prepare(CassandraProcessEngineConfiguration config) {
        selectActiveStatement = config.getSession().prepare(SELECT_ACTIVE);
        selectStatement = config.getSession().prepare(SELECT);
        shardSizeMillis = config.getJobShardSizeHours() * 3600 * 1000;
        shardInitNumber = config.getJobShardInitNumber();
        long currentShard = IndexUtils.calculateShard(System.currentTimeMillis(), shardSizeMillis);
        for (int i = 0; i < shardInitNumber; ++i) {
            if (SelectNextJobsToExecute.checkActive(currentShard = IndexUtils.calculateShard(currentShard - 1L, shardSizeMillis), false, config.getSession())) {
                activeShards.add(0, currentShard);
            }
            if (!SelectNextJobsToExecute.checkActive(currentShard, true, config.getSession())) continue;
            activeLockedShards.add(0, currentShard);
        }
    }

    @Override
    public List<JobEntity> executeQuery(CassandraPersistenceSession session, ListQueryParameterObject query) {
        long currentShard = IndexUtils.calculateShard(System.currentTimeMillis(), shardSizeMillis);
        Map params = (Map)query.getParameter();
        Date now = (Date)params.get("now");
        int maxResults = query.getMaxResults();
        ArrayList<JobEntity> result = new ArrayList<JobEntity>();
        this.queryShards(activeLockedShards, result, now, maxResults, session, currentShard, true);
        if (result.size() < maxResults) {
            this.queryShards(activeShards, result, now, maxResults, session, currentShard, false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryShards(List<Long> shards, List<JobEntity> result, Date now, int maxResults, CassandraPersistenceSession session, long currentShard, boolean locked) {
        ArrayList<Long> localShards = new ArrayList<Long>();
        List<Long> list = shards;
        synchronized (list) {
            if (shards.isEmpty() || shards.get(shards.size() - 1) < currentShard) {
                shards.add(currentShard);
            }
            localShards.addAll(shards);
        }
        long prevShard = IndexUtils.calculateShard(currentShard - 1L, shardSizeMillis);
        block3: for (Long shard : localShards) {
            BoundStatement statement = selectStatement.bind();
            statement.setDate("shard_id", new Date(shard));
            statement.setBool("is_locked", locked);
            statement.setDate(2, now);
            statement.setInt(3, maxResults);
            List rows = session.getSession().execute((Statement)statement).all();
            for (Row row : rows) {
                JobEntity job = session.selectById(JobEntity.class, row.getString("id"));
                if (job != null) {
                    result.add(job);
                }
                if (result.size() < maxResults) continue;
                break block3;
            }
            if (!rows.isEmpty() || shard >= prevShard || SelectNextJobsToExecute.checkActive(shard, locked, session.getSession())) continue;
            shards.remove(shard);
        }
    }

    private static boolean checkActive(long shard, boolean locked, Session session) {
        BoundStatement statement = selectActiveStatement.bind();
        statement.setDate("shard_id", new Date(shard));
        statement.setBool("is_locked", locked);
        statement.setInt(2, 1);
        Row row = session.execute((Statement)statement).one();
        return row != null;
    }

    static {
        activeShards = Collections.synchronizedList(new LinkedList());
        activeLockedShards = Collections.synchronizedList(new LinkedList());
    }
}

