/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.serializer;

import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.utils.Bytes;
import java.nio.ByteBuffer;
import org.camunda.bpm.engine.cassandra.provider.serializer.CassandraSerializer;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;

public class ResourceEntitySerializer
implements CassandraSerializer<ResourceEntity> {
    @Override
    public void write(SettableData<?> data, ResourceEntity entity) {
        data.setString("id", entity.getId());
        data.setString("name", entity.getName());
        data.setString("deployment_id", entity.getDeploymentId());
        data.setBytes("content", ByteBuffer.wrap(entity.getBytes()));
    }

    @Override
    public ResourceEntity read(GettableData data) {
        ResourceEntity resourceEntity = new ResourceEntity();
        resourceEntity.setId(data.getString("id"));
        resourceEntity.setDeploymentId(data.getString("deployment_id"));
        resourceEntity.setName(data.getString("name"));
        resourceEntity.setBytes(Bytes.getArray((ByteBuffer)data.getBytes("content")));
        return resourceEntity;
    }

    @Override
    public ResourceEntity copy(ResourceEntity data) {
        throw new UnsupportedOperationException();
    }
}

