/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cassandra.provider.table;

import com.datastax.driver.core.Session;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.cassandra.provider.table.TableHandler;

public class JobTableHandler
implements TableHandler {
    public static final String TABLE_NAME = "cam_job";
    public static final String JOB_INDEX_TABLE = "cam_job_idx";
    protected static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS cam_job (id text, type text, due_date timestamp, lock_exp_time timestamp, lock_owner text, exclusive boolean, execution_id text, process_instance_id text, process_def_id text, process_def_key text, retries int, exception_stack_id text, exception_message text, repeat text, handler_type text, handler_cfg text, deployment_id text, suspension_state int, job_def_id text, sequence_counter bigint, priority bigint, revision int, PRIMARY KEY (id) ); ";
    protected static final String CREATE_INDEX = "CREATE TABLE IF NOT EXISTS cam_job_idx (shard_id timestamp, is_locked boolean, sort_time timestamp, id text, PRIMARY KEY ((shard_id, is_locked), sort_time, id) ) WITH CLUSTERING ORDER BY (sort_time ASC);";
    protected static final String DROP_TABLE = "DROP TABLE IF EXISTS cam_job";
    protected static final String DROP_INDEX = "DROP TABLE IF EXISTS cam_job_idx";

    @Override
    public List<String> getTableNames() {
        return Arrays.asList(TABLE_NAME, JOB_INDEX_TABLE);
    }

    @Override
    public void createTable(Session s) {
        s.execute(CREATE_TABLE);
        s.execute(CREATE_INDEX);
    }

    @Override
    public void dropTable(Session s) {
        s.execute(DROP_TABLE);
        s.execute(DROP_INDEX);
    }
}

