/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cfg.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.standalone.StandaloneTransactionContextFactory;
import org.camunda.bpm.engine.impl.db.hazelcast.HazelcastPersistenceProviderFactory;
import org.camunda.bpm.engine.impl.db.hazelcast.HazelcastSessionFactory;
import org.camunda.bpm.engine.impl.db.hazelcast.serialization.PortableSerialization;
import org.camunda.bpm.engine.impl.interceptor.CommandContextInterceptor;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;
import org.camunda.bpm.engine.impl.interceptor.LogInterceptor;
import org.camunda.bpm.engine.impl.persistence.StrongUuidGenerator;

public class HazelcastProcessEngineConfiguration
extends ProcessEngineConfigurationImpl {
    private static Logger LOG = Logger.getLogger(HazelcastProcessEngineConfiguration.class.getName());
    protected Config hazelcastConfig;
    protected HazelcastInstance hazelcastInstance;
    public static List<String> members = new ArrayList<String>();
    public static String manager = null;

    public HazelcastProcessEngineConfiguration() {
        this.setHistory("none");
        this.setCmmnEnabled(false);
        this.setDmnEnabled(false);
        this.setAuthorizationEnabled(false);
        this.setMetricsEnabled(false);
        this.setJobExecutorActivate(false);
        this.setDbMetricsReporterActivate(false);
        this.setDeploymentLockUsed(false);
    }

    protected void init() {
        this.invokePreInit();
        this.initHazelcast();
        this.initDefaultCharset();
        this.initHistoryLevel();
        this.initHistoryEventProducer();
        this.initCmmnHistoryEventProducer();
        this.initHistoryEventHandler();
        this.initExpressionManager();
        this.initBeans();
        this.initArtifactFactory();
        this.initFormEngines();
        this.initFormTypes();
        this.initFormFieldValidators();
        this.initScripting();
        this.initBusinessCalendarManager();
        this.initCommandContextFactory();
        this.initTransactionContextFactory();
        this.initCommandExecutors();
        this.initServices();
        this.initIdGenerator();
        this.initDeployers();
        this.initIdentityProviderSessionFactory();
        this.initSessionFactories();
        this.initValueTypeResolver();
        this.initSerialization();
        this.initDelegateInterceptor();
        this.initEventHandlers();
        this.initProcessApplicationManager();
        this.initCorrelationHandler();
        this.initIncidentHandlers();
        this.initPasswordDigest();
        this.initDeploymentRegistration();
        this.initResourceAuthorizationProvider();
        this.initMetrics();
        this.invokePostInit();
    }

    protected void initHazelcast() {
        if (this.hazelcastInstance == null) {
            if (this.hazelcastConfig == null) {
                LOG.info("No Hazelcast configuration provided: using default configuration.");
                MulticastConfig multicastConfig = new MulticastConfig().setEnabled(false);
                TcpIpConfig tcpIpConfig = new TcpIpConfig().setEnabled(true).setMembers(members);
                JoinConfig joinConfig = new JoinConfig().setMulticastConfig(multicastConfig).setTcpIpConfig(tcpIpConfig);
                NetworkConfig networkConfig = new NetworkConfig().setJoin(joinConfig);
                this.hazelcastConfig = new Config().setNetworkConfig(networkConfig);
                SerializationConfig serializationConfig = PortableSerialization.defaultSerializationConfig();
                this.hazelcastConfig.setSerializationConfig(serializationConfig);
                if (manager != null) {
                    this.hazelcastConfig.setManagementCenterConfig(new ManagementCenterConfig().setUrl(manager).setEnabled(true));
                }
            }
            this.hazelcastInstance = Hazelcast.newHazelcastInstance((Config)this.hazelcastConfig);
        }
    }

    protected void initTransactionContextFactory() {
        if (this.transactionContextFactory == null) {
            this.transactionContextFactory = new StandaloneTransactionContextFactory();
        }
    }

    protected Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequired() {
        ArrayList<Object> defaultCommandInterceptorsTxRequired = new ArrayList<Object>();
        defaultCommandInterceptorsTxRequired.add(new LogInterceptor());
        defaultCommandInterceptorsTxRequired.add(new CommandContextInterceptor(this.commandContextFactory, (ProcessEngineConfigurationImpl)this));
        return defaultCommandInterceptorsTxRequired;
    }

    protected Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequiresNew() {
        ArrayList<Object> defaultCommandInterceptorsTxRequired = new ArrayList<Object>();
        defaultCommandInterceptorsTxRequired.add(new LogInterceptor());
        defaultCommandInterceptorsTxRequired.add(new CommandContextInterceptor(this.commandContextFactory, (ProcessEngineConfigurationImpl)this, true));
        return defaultCommandInterceptorsTxRequired;
    }

    protected void initIdGenerator() {
        if (this.idGenerator == null) {
            this.idGenerator = new StrongUuidGenerator();
        }
    }

    protected void initPersistenceProviders() {
        this.addSessionFactory(new HazelcastSessionFactory(this.hazelcastInstance));
        this.addSessionFactory(new HazelcastPersistenceProviderFactory());
    }

    public Config getHazelcastConfig() {
        return this.hazelcastConfig;
    }

    public void setHazelcastConfig(Config hazelcastConfig) {
        this.hazelcastConfig = hazelcastConfig;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public void close() {
        super.close();
        if (this.hazelcastInstance != null) {
            this.hazelcastInstance.shutdown();
        }
    }
}

