/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.transaction.TransactionContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.db.AbstractPersistenceSession;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbBulkOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbEntityOperation;
import org.camunda.bpm.engine.impl.db.hazelcast.HazelcastSessionFactory;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.DeleteStatementHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.SelectEntitiesStatementHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.SelectEntityStatementHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.serialization.AbstractPortableEntity;
import org.camunda.bpm.engine.impl.db.hazelcast.serialization.PortableSerialization;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class HazelcastPersistenceSession
extends AbstractPersistenceSession {
    private static final Logger log = Logger.getLogger(HazelcastPersistenceSession.class.getName());
    protected HazelcastInstance hazelcastInstance;
    protected TransactionContext transactionContext;

    public HazelcastPersistenceSession(HazelcastInstance hazelcastInstance, boolean openTransaction) {
        this.hazelcastInstance = hazelcastInstance;
        if (openTransaction) {
            this.transactionContext = hazelcastInstance.newTransactionContext();
            this.transactionContext.beginTransaction();
        }
    }

    public TransactionalMap<Object, Object> getTransactionalMap(String mapName) {
        return this.transactionContext.getMap(mapName);
    }

    public <T extends AbstractPortableEntity<?>> TransactionalMap<String, T> getTransactionalMap(DbEntityOperation operation) {
        return this.getTransactionalMap(operation.getEntityType());
    }

    public <T extends AbstractPortableEntity<?>> TransactionalMap<String, T> getTransactionalMap(Class<? extends DbEntity> type) {
        return this.getTransactionalMap(HazelcastSessionFactory.getMapNameForEntityType(type));
    }

    public IMap<Object, Object> getMap(String mapName) {
        return this.hazelcastInstance.getMap(mapName);
    }

    public <T extends AbstractPortableEntity<?>> IMap<String, T> getMap(DbEntityOperation operation) {
        return (IMap)this.getTransactionalMap(operation.getEntityType());
    }

    public <T extends AbstractPortableEntity<?>> IMap<String, T> getMap(Class<? extends DbEntity> type) {
        return (IMap)this.getTransactionalMap(HazelcastSessionFactory.getMapNameForEntityType(type));
    }

    protected void insertEntity(DbEntityOperation operation) {
        DbEntity entity = operation.getEntity();
        if (entity instanceof HasDbRevision) {
            ((HasDbRevision)entity).setRevision(1);
        }
        Object portable = PortableSerialization.createPortableInstance(entity);
        this.getTransactionalMap(operation).put((Object)entity.getId(), portable);
    }

    protected void deleteEntity(DbEntityOperation operation) {
        TransactionalMap map = this.getTransactionalMap(operation);
        DbEntity removedEntity = operation.getEntity();
        if (removedEntity instanceof HasDbRevision) {
            HasDbRevision removedRevision = (HasDbRevision)removedEntity;
            AbstractPortableEntity dbPortable = (AbstractPortableEntity)map.remove((Object)removedEntity.getId());
            EnsureUtil.ensureNotNull(OptimisticLockingException.class, (String)"dbRevision", (Object)dbPortable);
            HasDbRevision dbRevision = (HasDbRevision)dbPortable.getEntity();
            if (dbRevision.getRevision() != removedRevision.getRevision()) {
                throw new OptimisticLockingException(removedEntity + " was updated by another transaction concurrently");
            }
        } else {
            map.remove((Object)removedEntity.getId());
        }
    }

    protected void updateEntity(DbEntityOperation operation) {
        TransactionalMap map = this.getTransactionalMap(operation);
        DbEntity updatedEntity = operation.getEntity();
        Object portable = PortableSerialization.createPortableInstance(updatedEntity);
        if (updatedEntity instanceof HasDbRevision) {
            HasDbRevision updatedRevision = (HasDbRevision)updatedEntity;
            int oldRevision = updatedRevision.getRevision();
            updatedRevision.setRevision(updatedRevision.getRevisionNext());
            AbstractPortableEntity dbPortable = (AbstractPortableEntity)map.put((Object)updatedEntity.getId(), portable);
            EnsureUtil.ensureNotNull(OptimisticLockingException.class, (String)"dbRevision", (Object)dbPortable);
            HasDbRevision dbRevision = (HasDbRevision)dbPortable.getEntity();
            if (dbRevision.getRevision() != oldRevision) {
                throw new OptimisticLockingException(updatedEntity + " was updated by another transaction concurrently");
            }
        } else {
            map.put((Object)updatedEntity.getId(), portable);
        }
    }

    protected void deleteBulk(DbBulkOperation operation) {
        String statement = operation.getStatement();
        if (log.isLoggable(Level.FINE)) {
            log.fine("executing deleteBulk " + statement);
        }
        Object parameter = operation.getParameter();
        DeleteStatementHandler statementHandler = HazelcastSessionFactory.getDeleteStatementHandler(statement);
        if (statementHandler != null) {
            statementHandler.execute(this, parameter);
        } else {
            log.log(Level.WARNING, "Delete statement '{}' currently not supported", statement);
        }
    }

    protected void updateBulk(DbBulkOperation operation) {
    }

    protected String getDbVersion() {
        return "fox";
    }

    protected void dbSchemaCreateIdentity() {
    }

    protected void dbSchemaCreateHistory() {
    }

    protected void dbSchemaCreateEngine() {
        IMap executionMap = this.hazelcastInstance.getMap(HazelcastSessionFactory.getMapNameForEntityType(ExecutionEntity.class));
        executionMap.addIndex("parentId", false);
        executionMap.addIndex("processInstanceId", false);
        executionMap.addIndex("processDefinitionId", false);
    }

    protected void dbSchemaCreateCmmn() {
    }

    protected void dbSchemaDropIdentity() {
    }

    protected void dbSchemaDropHistory() {
    }

    protected void dbSchemaDropEngine() {
        for (String mapNames : HazelcastSessionFactory.entityMapping.values()) {
            this.getMap(mapNames).destroy();
        }
    }

    protected void dbSchemaDropCmmn() {
    }

    public boolean isEngineTablePresent() {
        return true;
    }

    public boolean isHistoryTablePresent() {
        return true;
    }

    public boolean isIdentityTablePresent() {
        return true;
    }

    public boolean isCaseDefinitionTablePresent() {
        return true;
    }

    public List<?> selectList(String statement, Object parameter) {
        SelectEntitiesStatementHandler statementHandler;
        if (log.isLoggable(Level.FINE)) {
            log.fine("executing selectList " + statement);
        }
        if ((statementHandler = HazelcastSessionFactory.getSelectEntitiesStatementHandler(statement)) != null) {
            List<?> result = statementHandler.execute(this, parameter);
            for (Object object : result) {
                this.fireEntityLoaded(object);
            }
            return result;
        }
        log.log(Level.WARNING, "SELECT many statement '{}' currently not supported", statement);
        return Collections.emptyList();
    }

    public <T extends DbEntity> T selectById(Class<T> type, String id) {
        AbstractPortableEntity portable = (AbstractPortableEntity)this.getTransactionalMap(type).get((Object)id);
        if (portable != null) {
            Object entity = portable.getEntity();
            this.fireEntityLoaded(entity);
            return entity;
        }
        return null;
    }

    public Object selectOne(String statement, Object parameter) {
        SelectEntityStatementHandler statementHandler;
        if (log.isLoggable(Level.FINE)) {
            log.fine("executing selectOne " + statement);
        }
        if ((statementHandler = HazelcastSessionFactory.getSelectEntityStatementHandler(statement)) != null) {
            Object dbEntity = statementHandler.execute(this, parameter);
            if (dbEntity != null) {
                this.fireEntityLoaded(dbEntity);
            }
            return dbEntity;
        }
        log.log(Level.WARNING, "SELECT one statement '{}' currently not supported", statement);
        return null;
    }

    public void lock(String statement) {
    }

    public void commit() {
        if (this.transactionContext != null) {
            this.transactionContext.commitTransaction();
        }
    }

    public void rollback() {
        if (this.transactionContext != null) {
            this.transactionContext.rollbackTransaction();
        }
    }

    public void flush() {
    }

    public void close() {
    }

    public void dbSchemaCheckVersion() {
    }

    public Map<String, Long> getMapCounts() {
        HashMap<String, Long> counts = new HashMap<String, Long>();
        Collection<String> mapNames = HazelcastSessionFactory.entityMapping.values();
        for (String mapName : mapNames) {
            counts.put(mapName, Integer.valueOf(this.getTransactionalMap(mapName).size()).longValue());
        }
        return counts;
    }

    public void lock(String statement, Object parameter) {
    }

    protected void dbSchemaCreateCmmnHistory() {
    }

    protected void dbSchemaCreateDmn() {
    }

    protected void dbSchemaDropCmmnHistory() {
    }

    protected void dbSchemaDropDmn() {
    }

    public boolean isCmmnTablePresent() {
        return false;
    }

    public boolean isCmmnHistoryTablePresent() {
        return false;
    }

    public boolean isDmnTablePresent() {
        return false;
    }
}

