/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.hazelcast.HazelcastPersistenceSession;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.DeleteEntitiesByDeploymentIdHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.DeleteEntityByIdHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.DeleteEntityByKeyHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.DeleteStatementHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.SelectEntitiesByKeyHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.SelectEntitiesStatementHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.SelectEntityByIdHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.SelectEntityStatementHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.SelectEventSubscriptionsByConfiguration;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.SelectEventSubscriptionsByQueryCriteriaStatementHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.SelectExecutionsByQueryCriteriaStatementHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.SelectJobByConfigurationHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.SelectLatestProcessDefinitionHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.SelectProcessDefinitionByDeploymentAndKeyHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.SelectProcessDefinitionsByCriteriaStatementHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.SelectProcessInstanceByQueryCriteriaStatementHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.SelectProcessInstanceIdsByKeyHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.SelectTasksByQueryCriteriaStatementHandler;
import org.camunda.bpm.engine.impl.db.hazelcast.handler.SelectVariableInstancesByQueryCriteriaStatementHandler;
import org.camunda.bpm.engine.impl.interceptor.Session;
import org.camunda.bpm.engine.impl.interceptor.SessionFactory;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityLinkEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class HazelcastSessionFactory
implements SessionFactory {
    public static final String ENGINE_DEPLOYMENT_MAP_NAME = "cam.engine.deployment";
    public static final String ENGINE_BYTE_ARRAY_MAP_NAME = "cam.engine.byte_array";
    public static final String ENGINE_PROCESS_DEFINITION_MAP_NAME = "cam.engine.process_definition";
    public static final String ENGINE_PROPERTY_MAP_NAME = "cam.engine.property";
    public static final String ENGINE_EXECUTION_MAP_NAME = "cam.engine.execution";
    public static final String ENGINE_JOB_MAP_NAME = "cam.engine.job";
    public static final String ENGINE_JOB_DEFINITION_MAP_NAME = "cam.engine.job_definition";
    public static final String ENGINE_EVENT_SUBSCRIPTION_MAP_NAME = "cam.engine.event_subscription";
    public static final String ENGINE_IDENTITY_LINK_MAP_NAME = "cam.engine.identity_link";
    public static final String ENGINE_TASK_MAP_NAME = "cam.engine.task";
    public static final String ENGINE_VARIABLE_INSTANCE_MAP_NAME = "cam.engine.variable";
    public static final String ENGINE_CASE_DEFINITION_MAP_NAME = "cam.engine.case_definition";
    public static final Map<Class<? extends DbEntity>, String> entityMapping = new HashMap<Class<? extends DbEntity>, String>();
    public static Map<String, DeleteStatementHandler> deleteStatementHandler;
    public static Map<String, SelectEntityStatementHandler> selectEntityStatementHandler;
    public static Map<String, SelectEntitiesStatementHandler> selectEntitiesStatementHandler;
    protected HazelcastInstance hazelcastInstance;

    public HazelcastSessionFactory(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public Class<?> getSessionType() {
        return HazelcastPersistenceSession.class;
    }

    public Session openSession() {
        return new HazelcastPersistenceSession(this.hazelcastInstance, true);
    }

    public static String getMapNameForEntityType(Class<? extends DbEntity> type) {
        String mapName = entityMapping.get(type);
        EnsureUtil.ensureNotNull((String)("Entity type '" + type + "' currently not supported"), (String)"mapName", (Object)mapName);
        return mapName;
    }

    public static DeleteStatementHandler getDeleteStatementHandler(String statement) {
        return deleteStatementHandler.get(statement);
    }

    public static SelectEntityStatementHandler getSelectEntityStatementHandler(String statement) {
        return selectEntityStatementHandler.get(statement);
    }

    public static SelectEntitiesStatementHandler getSelectEntitiesStatementHandler(String statement) {
        return selectEntitiesStatementHandler.get(statement);
    }

    static {
        entityMapping.put(DeploymentEntity.class, ENGINE_DEPLOYMENT_MAP_NAME);
        entityMapping.put(ResourceEntity.class, ENGINE_BYTE_ARRAY_MAP_NAME);
        entityMapping.put(ByteArrayEntity.class, ENGINE_BYTE_ARRAY_MAP_NAME);
        entityMapping.put(ProcessDefinitionEntity.class, ENGINE_PROCESS_DEFINITION_MAP_NAME);
        entityMapping.put(PropertyEntity.class, ENGINE_PROPERTY_MAP_NAME);
        entityMapping.put(ExecutionEntity.class, ENGINE_EXECUTION_MAP_NAME);
        entityMapping.put(JobEntity.class, ENGINE_JOB_MAP_NAME);
        entityMapping.put(JobDefinitionEntity.class, ENGINE_JOB_DEFINITION_MAP_NAME);
        entityMapping.put(EventSubscriptionEntity.class, ENGINE_EVENT_SUBSCRIPTION_MAP_NAME);
        entityMapping.put(CompensateEventSubscriptionEntity.class, ENGINE_EVENT_SUBSCRIPTION_MAP_NAME);
        entityMapping.put(MessageEventSubscriptionEntity.class, ENGINE_EVENT_SUBSCRIPTION_MAP_NAME);
        entityMapping.put(SignalEventSubscriptionEntity.class, ENGINE_EVENT_SUBSCRIPTION_MAP_NAME);
        entityMapping.put(IdentityLinkEntity.class, ENGINE_IDENTITY_LINK_MAP_NAME);
        entityMapping.put(TaskEntity.class, ENGINE_TASK_MAP_NAME);
        entityMapping.put(VariableInstanceEntity.class, ENGINE_VARIABLE_INSTANCE_MAP_NAME);
        entityMapping.put(CaseDefinitionEntity.class, ENGINE_CASE_DEFINITION_MAP_NAME);
        deleteStatementHandler = new HashMap<String, DeleteStatementHandler>();
        deleteStatementHandler.put("deleteResourcesByDeploymentId", new DeleteEntitiesByDeploymentIdHandler(ResourceEntity.class));
        deleteStatementHandler.put("deleteCaseDefinitionsByDeploymentId", new DeleteEntitiesByDeploymentIdHandler(CaseDefinitionEntity.class));
        deleteStatementHandler.put("deleteProcessDefinitionsByDeploymentId", new DeleteEntitiesByDeploymentIdHandler(ProcessDefinitionEntity.class));
        deleteStatementHandler.put("deleteDeployment", new DeleteEntityByIdHandler(DeploymentEntity.class));
        deleteStatementHandler.put("deleteIdentityLinkByProcDef", new DeleteEntityByKeyHandler(IdentityLinkEntity.class, "processDefId"));
        deleteStatementHandler.put("deleteJobDefinitionsByProcessDefinitionId", new DeleteEntityByKeyHandler(JobDefinitionEntity.class, "processDefinitionId"));
        deleteStatementHandler.put("deleteByteArrayNoRevisionCheck", new DeleteEntityByIdHandler(ByteArrayEntity.class));
        selectEntityStatementHandler = new HashMap<String, SelectEntityStatementHandler>();
        selectEntityStatementHandler.put("selectExecution", new SelectEntityByIdHandler(ExecutionEntity.class));
        selectEntityStatementHandler.put("selectTask", new SelectEntityByIdHandler(TaskEntity.class));
        selectEntityStatementHandler.put("selectDeployment", new SelectEntityByIdHandler(DeploymentEntity.class));
        selectEntityStatementHandler.put("selectVariableInstance", new SelectEntityByIdHandler(VariableInstanceEntity.class));
        selectEntityStatementHandler.put("selectProcessDefinitionById", new SelectEntityByIdHandler(ProcessDefinitionEntity.class));
        selectEntityStatementHandler.put("selectLatestProcessDefinitionByKey", new SelectLatestProcessDefinitionHandler());
        selectEntityStatementHandler.put("selectProcessDefinitionByDeploymentAndKey", new SelectProcessDefinitionByDeploymentAndKeyHandler());
        selectEntityStatementHandler.put("selectJob", new SelectEntityByIdHandler(JobEntity.class));
        selectEntitiesStatementHandler = new HashMap<String, SelectEntitiesStatementHandler>();
        selectEntitiesStatementHandler.put("selectExecutionsByParentExecutionId", new SelectEntitiesByKeyHandler(ExecutionEntity.class, "parentId"));
        selectEntitiesStatementHandler.put("selectExecutionsByProcessInstanceId", new SelectEntitiesByKeyHandler(ExecutionEntity.class, "processInstanceId"));
        selectEntitiesStatementHandler.put("selectExecutionsByQueryCriteria", new SelectExecutionsByQueryCriteriaStatementHandler());
        selectEntitiesStatementHandler.put("selectProcessInstanceByQueryCriteria", new SelectProcessInstanceByQueryCriteriaStatementHandler());
        selectEntitiesStatementHandler.put("selectSubProcessInstanceBySuperCaseExecutionId", new SelectEntitiesByKeyHandler(ExecutionEntity.class, "superExecutionId"));
        selectEntitiesStatementHandler.put("selectTasksByParentTaskId", new SelectEntitiesByKeyHandler(TaskEntity.class, "parentTaskId"));
        selectEntitiesStatementHandler.put("selectTasksByExecutionId", new SelectEntitiesByKeyHandler(TaskEntity.class, "executionId"));
        selectEntitiesStatementHandler.put("selectTaskByCaseExecutionId", new SelectEntitiesByKeyHandler(TaskEntity.class, "caseExecutionId"));
        selectEntitiesStatementHandler.put("selectTasksByProcessInstanceId", new SelectEntitiesByKeyHandler(TaskEntity.class, "processInstanceId"));
        selectEntitiesStatementHandler.put("selectTaskByQueryCriteria", new SelectTasksByQueryCriteriaStatementHandler());
        selectEntitiesStatementHandler.put("selectVariablesByExecutionId", new SelectEntitiesByKeyHandler(VariableInstanceEntity.class, "executionId"));
        selectEntitiesStatementHandler.put("selectVariablesByCaseExecutionId", new SelectEntitiesByKeyHandler(VariableInstanceEntity.class, "caseExecutionId"));
        selectEntitiesStatementHandler.put("selectVariablesByTaskId", new SelectEntitiesByKeyHandler(VariableInstanceEntity.class, "taskId"));
        selectEntitiesStatementHandler.put("selectJobsByExecutionId", new SelectEntitiesByKeyHandler(JobEntity.class, "executionId"));
        selectEntitiesStatementHandler.put("selectJobsByConfiguration", new SelectJobByConfigurationHandler());
        selectEntitiesStatementHandler.put("selectProcessDefinitionByDeploymentId", new SelectEntitiesByKeyHandler(ProcessDefinitionEntity.class, "deploymentId"));
        selectEntitiesStatementHandler.put("selectProcessDefinitionsByQueryCriteria", new SelectProcessDefinitionsByCriteriaStatementHandler());
        selectEntitiesStatementHandler.put("selectCaseDefinitionByDeploymentId", new SelectEntitiesByKeyHandler(CaseDefinitionEntity.class, "deploymentId"));
        selectEntitiesStatementHandler.put("selectProcessInstanceIdsByProcessDefinitionId", new SelectProcessInstanceIdsByKeyHandler(ExecutionEntity.class, "processDefinitionId"));
        selectEntitiesStatementHandler.put("selectEventSubscriptionsByConfiguration", new SelectEventSubscriptionsByConfiguration());
        selectEntitiesStatementHandler.put("selectEventSubscriptionsByExecution", new SelectEntitiesByKeyHandler(EventSubscriptionEntity.class, "executionId"));
        selectEntitiesStatementHandler.put("selectEventSubscriptionByQueryCriteria", new SelectEventSubscriptionsByQueryCriteriaStatementHandler());
        selectEntitiesStatementHandler.put("selectIdentityLinksByTask", new SelectEntitiesByKeyHandler(IdentityLinkEntity.class, "taskId"));
        selectEntitiesStatementHandler.put("selectVariableInstanceByQueryCriteria", new SelectVariableInstancesByQueryCriteriaStatementHandler());
        selectEntitiesStatementHandler.put("selectResourcesByDeploymentId", new SelectEntitiesByKeyHandler(ResourceEntity.class, "deploymentId"));
    }
}

