/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db.hazelcast.handler;

import com.hazelcast.query.SqlPredicate;
import java.util.Map;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;

public class SqlPredicateFactory {
    public static SqlPredicate createSqlPredicate(String predicate) {
        return new SqlPredicate(predicate);
    }

    public static SqlPredicate createSqlPredicate(String predicate, Object ... args) {
        return SqlPredicateFactory.createSqlPredicate(String.format(predicate, args));
    }

    public static SqlPredicate createEqualPredicate(String key, Object value) {
        if (value instanceof ListQueryParameterObject) {
            value = ((ListQueryParameterObject)value).getParameter();
        }
        return SqlPredicateFactory.createSqlPredicate(String.format("%s = '%s'", key, value));
    }

    public static SqlPredicate createDeploymentIdPredicate(Object deploymentId) {
        return SqlPredicateFactory.createEqualPredicate("deploymentId", deploymentId);
    }

    public static SqlPredicate createParentExecutionIdPredicate(Object parentExecutionId) {
        return SqlPredicateFactory.createEqualPredicate("parentExecutionId", parentExecutionId);
    }

    public static SqlPredicate createAndPredicate(Map<String, Object> parameterMap) {
        String predicate = null;
        for (Map.Entry<String, Object> entry : parameterMap.entrySet()) {
            Object value = entry.getValue();
            if (predicate == null) {
                if (value instanceof String) {
                    predicate = String.format("%s == '%s'", entry.getKey(), value);
                    continue;
                }
                predicate = String.format("%s == %s", entry.getKey(), value);
                continue;
            }
            if (value instanceof String) {
                predicate = String.format("%s AND %s == '%s'", predicate, entry.getKey(), value);
                continue;
            }
            predicate = String.format("%s AND %s == %s", predicate, entry.getKey(), value);
        }
        return SqlPredicateFactory.createSqlPredicate(predicate);
    }
}

