/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db.hazelcast.serialization;

import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import java.io.IOException;
import java.util.Date;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.HasDbRevision;

public abstract class AbstractPortableEntity<T extends DbEntity>
implements Portable {
    public static final String REVISION_FIELD = "revision";
    public static final String ID_FIELD = "id";
    protected T wrappedEntity;

    public T getEntity() {
        return this.wrappedEntity;
    }

    public void setEntity(T wrappedEntity) {
        this.wrappedEntity = wrappedEntity;
    }

    public int getFactoryId() {
        return 1;
    }

    public void readPortable(PortableReader reader) throws IOException {
        this.wrappedEntity = this.createEntityInstance(reader);
        this.wrappedEntity.setId(new String(reader.readUTF(ID_FIELD)));
        if (this.wrappedEntity instanceof HasDbRevision) {
            HasDbRevision revisionedObject = (HasDbRevision)this.wrappedEntity;
            revisionedObject.setRevision(reader.readInt(REVISION_FIELD));
        }
        this.readEntityFields(reader);
    }

    protected abstract T createEntityInstance(PortableReader var1) throws IOException;

    protected abstract void readEntityFields(PortableReader var1) throws IOException;

    protected Date readDate(PortableReader reader, String fieldName) throws IOException {
        long value = reader.readLong(fieldName);
        if (value == -1L) {
            return null;
        }
        return new Date(value);
    }

    protected Long readLong(PortableReader reader, String fieldName) throws IOException {
        long value = reader.readLong(fieldName);
        if (value == Long.MIN_VALUE) {
            return null;
        }
        return value;
    }

    protected Double readDouble(PortableReader reader, String fieldName) throws IOException {
        double value = reader.readDouble(fieldName);
        if (value == Double.MIN_VALUE) {
            return null;
        }
        return value;
    }

    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeUTF(ID_FIELD, this.wrappedEntity.getId());
        if (this.wrappedEntity instanceof HasDbRevision) {
            HasDbRevision revisionedObject = (HasDbRevision)this.wrappedEntity;
            writer.writeInt(REVISION_FIELD, revisionedObject.getRevision());
        }
        this.writeEntityFields(writer);
    }

    protected abstract void writeEntityFields(PortableWriter var1) throws IOException;

    protected void writeDate(PortableWriter writer, String fieldName, Date date) throws IOException {
        long value = -1L;
        if (date != null) {
            value = date.getTime();
        }
        writer.writeLong(fieldName, value);
    }

    protected void writeLong(PortableWriter writer, String fieldName, Long longValue) throws IOException {
        long value = Long.MIN_VALUE;
        if (longValue != null) {
            value = longValue;
        }
        writer.writeLong(fieldName, value);
    }

    protected void writeDouble(PortableWriter writer, String fieldName, Double doubleValue) throws IOException {
        double value = Double.MIN_VALUE;
        if (doubleValue != null) {
            value = doubleValue;
        }
        writer.writeDouble(fieldName, value);
    }
}

