/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db.hazelcast.serialization;

import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import java.io.IOException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.db.hazelcast.serialization.AbstractPortableEntity;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SignalEventSubscriptionEntity;

public class PortableEventSubscriptionEntity
extends AbstractPortableEntity<EventSubscriptionEntity> {
    public static final int ID = 9;
    public static final String EVENT_TYPE_FIELD = "eventType";
    public static final String EVENT_NAME_FIELD = "eventName";
    public static final String EXECUTION_ID_FIELD = "executionId";
    public static final String PROCESS_INSTANCE_ID_FIELD = "processInstanceId";
    public static final String ACTIVITY_ID_FIELD = "activityId";
    public static final String CONFIGURATION_FIELD = "configuration";
    public static final String CREATED_FIELD = "created";

    public int getClassId() {
        return 9;
    }

    public static ClassDefinition getClassDefinition() {
        return new ClassDefinitionBuilder(1, 9).addUTFField("id").addIntField("revision").addUTFField(EVENT_TYPE_FIELD).addUTFField(EVENT_NAME_FIELD).addUTFField(EXECUTION_ID_FIELD).addUTFField(PROCESS_INSTANCE_ID_FIELD).addUTFField(ACTIVITY_ID_FIELD).addUTFField(CONFIGURATION_FIELD).addLongField(CREATED_FIELD).build();
    }

    @Override
    protected EventSubscriptionEntity createEntityInstance(PortableReader reader) throws IOException {
        String eventType = reader.readUTF(EVENT_TYPE_FIELD);
        if ("compensate".equals(eventType)) {
            return new CompensateEventSubscriptionEntity();
        }
        if ("message".equals(eventType)) {
            return new MessageEventSubscriptionEntity();
        }
        if ("signal".equals(eventType)) {
            return new SignalEventSubscriptionEntity();
        }
        throw new ProcessEngineException("No event subscription found for event type '" + eventType + "'");
    }

    @Override
    protected void readEntityFields(PortableReader reader) throws IOException {
        ((EventSubscriptionEntity)this.wrappedEntity).setEventName(reader.readUTF(EVENT_NAME_FIELD));
        ((EventSubscriptionEntity)this.wrappedEntity).setExecutionId(reader.readUTF(EXECUTION_ID_FIELD));
        ((EventSubscriptionEntity)this.wrappedEntity).setProcessInstanceId(reader.readUTF(PROCESS_INSTANCE_ID_FIELD));
        ((EventSubscriptionEntity)this.wrappedEntity).setActivityId(reader.readUTF(ACTIVITY_ID_FIELD));
        ((EventSubscriptionEntity)this.wrappedEntity).setConfiguration(reader.readUTF(CONFIGURATION_FIELD));
        ((EventSubscriptionEntity)this.wrappedEntity).setCreated(this.readDate(reader, CREATED_FIELD));
    }

    @Override
    protected void writeEntityFields(PortableWriter writer) throws IOException {
        writer.writeUTF(EVENT_TYPE_FIELD, ((EventSubscriptionEntity)this.wrappedEntity).getEventType());
        writer.writeUTF(EVENT_NAME_FIELD, ((EventSubscriptionEntity)this.wrappedEntity).getEventName());
        writer.writeUTF(EXECUTION_ID_FIELD, ((EventSubscriptionEntity)this.wrappedEntity).getExecutionId());
        writer.writeUTF(PROCESS_INSTANCE_ID_FIELD, ((EventSubscriptionEntity)this.wrappedEntity).getProcessInstanceId());
        writer.writeUTF(ACTIVITY_ID_FIELD, ((EventSubscriptionEntity)this.wrappedEntity).getActivityId());
        writer.writeUTF(CONFIGURATION_FIELD, ((EventSubscriptionEntity)this.wrappedEntity).getConfiguration());
        this.writeDate(writer, CREATED_FIELD, ((EventSubscriptionEntity)this.wrappedEntity).getCreated());
    }
}

