/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db.hazelcast.serialization;

import com.hazelcast.config.SerializationConfig;
import com.hazelcast.nio.serialization.PortableFactory;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.hazelcast.serialization.AbstractPortableEntity;
import org.camunda.bpm.engine.impl.db.hazelcast.serialization.PortableByteArrayEntity;
import org.camunda.bpm.engine.impl.db.hazelcast.serialization.PortableDeploymentEntity;
import org.camunda.bpm.engine.impl.db.hazelcast.serialization.PortableEntityFactory;
import org.camunda.bpm.engine.impl.db.hazelcast.serialization.PortableEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.db.hazelcast.serialization.PortableExecutionEntity;
import org.camunda.bpm.engine.impl.db.hazelcast.serialization.PortableProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.db.hazelcast.serialization.PortablePropertyEntity;
import org.camunda.bpm.engine.impl.db.hazelcast.serialization.PortableResourceEntity;
import org.camunda.bpm.engine.impl.db.hazelcast.serialization.PortableTaskEntity;
import org.camunda.bpm.engine.impl.db.hazelcast.serialization.PortableVariableInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;

public class PortableSerialization {
    public static Map<Class<? extends DbEntity>, Class<? extends AbstractPortableEntity<?>>> entityMapping = new HashMap();

    public static <T extends AbstractPortableEntity<?>> T createPortableInstance(DbEntity entity) {
        Class<?> type = entity.getClass();
        Class<? extends AbstractPortableEntity<?>> portableType = entityMapping.get(type);
        EnsureUtil.ensureNotNull((String)("Cannot find portable type for entity type " + type), (String)"portable type", portableType);
        AbstractPortableEntity portable = (AbstractPortableEntity)ReflectUtil.instantiate(portableType);
        portable.setEntity(entity);
        return (T)portable;
    }

    public static SerializationConfig defaultSerializationConfig() {
        SerializationConfig serializationConfig = new SerializationConfig();
        serializationConfig.addClassDefinition(PortablePropertyEntity.getClassDefinition());
        serializationConfig.addClassDefinition(PortableExecutionEntity.getClassDefinition());
        serializationConfig.addClassDefinition(PortableDeploymentEntity.getClassDefinition());
        serializationConfig.addClassDefinition(PortableResourceEntity.getClassDefinition());
        serializationConfig.addClassDefinition(PortableProcessDefinitionEntity.getClassDefinition());
        serializationConfig.addClassDefinition(PortableTaskEntity.getClassDefinition());
        serializationConfig.addClassDefinition(PortableVariableInstanceEntity.getClassDefinition());
        serializationConfig.addClassDefinition(PortableByteArrayEntity.getClassDefinition());
        serializationConfig.addClassDefinition(PortableEventSubscriptionEntity.getClassDefinition());
        serializationConfig.addPortableFactory(1, (PortableFactory)new PortableEntityFactory());
        return serializationConfig;
    }

    static {
        entityMapping.put(PropertyEntity.class, PortablePropertyEntity.class);
        entityMapping.put(ExecutionEntity.class, PortableExecutionEntity.class);
        entityMapping.put(DeploymentEntity.class, PortableDeploymentEntity.class);
        entityMapping.put(ResourceEntity.class, PortableResourceEntity.class);
        entityMapping.put(ProcessDefinitionEntity.class, PortableProcessDefinitionEntity.class);
        entityMapping.put(TaskEntity.class, PortableTaskEntity.class);
        entityMapping.put(VariableInstanceEntity.class, PortableVariableInstanceEntity.class);
        entityMapping.put(ByteArrayEntity.class, PortableByteArrayEntity.class);
        entityMapping.put(CompensateEventSubscriptionEntity.class, PortableEventSubscriptionEntity.class);
        entityMapping.put(MessageEventSubscriptionEntity.class, PortableEventSubscriptionEntity.class);
        entityMapping.put(SignalEventSubscriptionEntity.class, PortableEventSubscriptionEntity.class);
    }
}

