/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.batch.spring;

import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.extension.batch.CustomBatchJobHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionProxyFactoryBean;

public abstract class FailsafeCustomBatchJobHandler<T>
extends CustomBatchJobHandler<T> {
    private static Properties TRANSACTION_ATTRIBUTES = new Properties(){
        {
            this.put("*", "PROPAGATION_REQUIRES_NEW");
        }
    };
    private final PlatformTransactionManager transactionManager;

    @Autowired
    public FailsafeCustomBatchJobHandler(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    protected <T> T requireNewTransaction(T target) {
        TransactionProxyFactoryBean proxy = new TransactionProxyFactoryBean();
        proxy.setTransactionManager(this.transactionManager);
        proxy.setTarget(target);
        proxy.setTransactionAttributes(TRANSACTION_ATTRIBUTES);
        proxy.setProxyTargetClass(true);
        proxy.afterPropertiesSet();
        return (T)proxy.getObject();
    }

    public void execute(List<T> data, CommandContext commandContext) {
        data.forEach(s -> {
            BiConsumer<Object, CommandContext> executeFailsafe = this::executeFailsafe;
            try {
                this.requireNewTransaction(executeFailsafe).accept(s, commandContext);
            }
            catch (RuntimeException e) {
                this.handleRuntimeException(e);
            }
        });
    }

    public abstract void executeFailsafe(T var1, CommandContext var2);

    public void handleRuntimeException(RuntimeException runtimeException) {
    }
}

