/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.scenario.impl;

import java.util.Date;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.scenario.defer.Deferred;
import org.camunda.bpm.scenario.impl.AbstractExecutable;
import org.camunda.bpm.scenario.impl.Executable;
import org.camunda.bpm.scenario.impl.ProcessRunnerImpl;
import org.camunda.bpm.scenario.impl.util.Time;

public class DeferredExecutable
extends AbstractExecutable<HistoricActivityInstance> {
    private static int sequence;
    private Integer id = ++sequence;
    private Date isExecutableAt;
    private Deferred action;

    protected DeferredExecutable(ProcessRunnerImpl runner, HistoricActivityInstance instance, String period, Deferred action) {
        super(runner);
        this.delegate = instance;
        this.isExecutableAt = Time.dateAfter(period);
        this.action = action;
        Executable.Deferreds.add(this);
    }

    @Override
    public String getExecutionId() {
        return ((HistoricActivityInstance)this.delegate).getExecutionId();
    }

    @Override
    protected HistoricActivityInstance getDelegate() {
        return (HistoricActivityInstance)this.getHistoryService().createHistoricActivityInstanceQuery().activityInstanceId(((HistoricActivityInstance)this.delegate).getId()).unfinished().singleResult();
    }

    @Override
    protected Date isExecutableAt() {
        return this.isExecutableAt;
    }

    @Override
    public void execute() {
        if (this.getDelegate() != null) {
            Time.set(this.isExecutableAt());
            try {
                this.action.execute();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Executable.Deferreds.remove(this);
    }

    @Override
    public int compareTo(AbstractExecutable other) {
        int compare = super.compareTo(other);
        return compare == 0 ? this.id.compareTo(((DeferredExecutable)other).id) : compare;
    }
}

