/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.scenario.impl.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public class Api {
    private static Logger log = Logger.getLogger(Api.class.getName());
    private String className;
    private String methodName;
    private Class<?>[] parameterTypes;
    private String signature;
    private static Map<String, Boolean> support = new HashMap<String, Boolean>();

    private Api(String className, String methodName, Class<?> ... parameterTypes) {
        this.className = className;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.signature = this.signature();
        if (!support.containsKey(this.signature)) {
            support.put(this.signature, this.supported());
        }
    }

    public static Api feature(String className) {
        return Api.feature(className, null, new Class[0]);
    }

    public static Api feature(String className, String methodName, Class<?> ... parameterTypes) {
        return new Api(className, methodName, parameterTypes);
    }

    public void fail() {
        this.fail(this.message());
    }

    public void fail(String message) {
        if (!this.isSupported()) {
            throw new UnsupportedOperationException(message);
        }
    }

    public boolean warn() {
        return this.warn(this.message());
    }

    public boolean warn(String message) {
        Boolean supported = support.get(this.signature);
        if (supported != null && !supported.booleanValue()) {
            support.put(this.signature, null);
            log.warning(message);
        }
        return this.isSupported();
    }

    public boolean isSupported() {
        Boolean s = support.get(this.signature);
        return s != null && s != false;
    }

    private String message() {
        StringBuffer buffer = new StringBuffer("Usage of API '").append(this.signature).append("' requested, but not supported by the classes found in classpath.");
        return buffer.toString();
    }

    private String signature() {
        StringBuffer buffer = new StringBuffer(this.className);
        if (this.methodName != null) {
            buffer.append(".").append(this.methodName);
            buffer.append("(");
            if (this.parameterTypes != null && this.parameterTypes.length > 0) {
                Iterator<Class<?>> it = Arrays.asList(this.parameterTypes).iterator();
                while (it.hasNext()) {
                    buffer.append(it.next().getSimpleName());
                    if (!it.hasNext()) continue;
                    buffer.append(", ");
                }
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    private boolean supported() {
        try {
            Class.forName(this.className).getMethod(this.methodName, this.parameterTypes);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }
}

