/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.scenario.impl;

import java.util.Date;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.scenario.ProcessScenario;
import org.camunda.bpm.scenario.act.Action;
import org.camunda.bpm.scenario.defer.Deferred;
import org.camunda.bpm.scenario.delegate.ProcessInstanceDelegate;
import org.camunda.bpm.scenario.impl.AbstractExecutable;
import org.camunda.bpm.scenario.impl.Executable;
import org.camunda.bpm.scenario.impl.ProcessRunnerImpl;
import org.camunda.bpm.scenario.impl.delegate.ProcessInstanceDelegateImpl;
import org.camunda.bpm.scenario.impl.util.Log;
import org.camunda.bpm.scenario.impl.util.Time;

public abstract class WaitstateExecutable<I>
extends AbstractExecutable<I> {
    protected HistoricActivityInstance historicDelegate;

    protected WaitstateExecutable(ProcessRunnerImpl runner, HistoricActivityInstance instance) {
        super(runner);
        this.historicDelegate = instance;
        this.delegate = this.getDelegate();
    }

    public ProcessInstanceDelegate getProcessInstance() {
        return ProcessInstanceDelegateImpl.newInstance(this, this.runner.processInstance);
    }

    @Override
    public String getExecutionId() {
        return this.historicDelegate.getExecutionId();
    }

    public String getActivityId() {
        return this.historicDelegate.getActivityId();
    }

    @Override
    public void execute() {
        Action action = this.action();
        if (action == null) {
            throw new AssertionError((Object)("Process Instance {" + this.getProcessInstance().getProcessDefinitionId() + ", " + this.getProcessInstance().getProcessInstanceId() + "} " + "waits at an unexpected " + this.getClass().getSimpleName().substring(0, this.getClass().getSimpleName().length() - 10) + " '" + this.historicDelegate.getActivityId() + "'."));
        }
        Time.set(this.isExecutableAt());
        try {
            Log.Action.ActingOn.log(this.historicDelegate.getActivityType(), this.historicDelegate.getActivityName(), this.historicDelegate.getActivityId(), this.runner.getProcessDefinitionKey(), this.historicDelegate.getProcessInstanceId(), null, null);
            action.execute(this);
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        this.runner.setExecuted(this);
    }

    protected abstract Action action(ProcessScenario var1);

    protected final Action action() {
        return this.action(this.runner.scenario);
    }

    @Override
    public Date isExecutableAt() {
        return this.historicDelegate.getStartTime();
    }

    public void defer(String period, Deferred action) {
        Executable.Deferreds.newInstance(this.runner, this.historicDelegate, period, action);
    }

    @Override
    public int compareTo(AbstractExecutable other) {
        int compare = super.compareTo(other);
        return compare == 0 ? idComparator.compare(this.historicDelegate.getId(), ((WaitstateExecutable)other).historicDelegate.getId()) : compare;
    }
}

