/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.scenario.impl.waitstate;

import java.util.Map;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.scenario.ProcessScenario;
import org.camunda.bpm.scenario.act.Action;
import org.camunda.bpm.scenario.impl.ProcessRunnerImpl;
import org.camunda.bpm.scenario.impl.delegate.AbstractExternalTaskDelegate;

public class ServiceTaskExecutable
extends AbstractExternalTaskDelegate {
    private static final String WORKER_ID = "workerId";

    public ServiceTaskExecutable(ProcessRunnerImpl runner, HistoricActivityInstance instance) {
        super(runner, instance);
    }

    @Override
    protected ExternalTask getDelegate() {
        return (ExternalTask)this.getExternalTaskService().createExternalTaskQuery().executionId(this.getExecutionId()).singleResult();
    }

    @Override
    protected Action action(ProcessScenario scenario) {
        return scenario.waitsAtServiceTask(this.getActivityId());
    }

    protected void fetchAndLock() {
        this.getExternalTaskService().fetchAndLock(Integer.MAX_VALUE, WORKER_ID).topic(this.getDelegate().getTopicName(), Long.MAX_VALUE).execute();
    }

    @Override
    public void complete() {
        this.fetchAndLock();
        this.getExternalTaskService().complete(this.getDelegate().getId(), WORKER_ID);
    }

    @Override
    public void complete(Map<String, Object> variables) {
        this.fetchAndLock();
        this.getExternalTaskService().complete(this.getDelegate().getId(), WORKER_ID, variables);
    }

    @Override
    public void handleBpmnError(String errorCode) {
        this.fetchAndLock();
        this.getExternalTaskService().handleBpmnError(this.getDelegate().getId(), WORKER_ID, errorCode);
    }
}

