/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.scenario.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.scenario.ProcessScenario;
import org.camunda.bpm.scenario.Scenario;
import org.camunda.bpm.scenario.impl.AbstractRunner;
import org.camunda.bpm.scenario.impl.Executable;
import org.camunda.bpm.scenario.impl.ScenarioImpl;
import org.camunda.bpm.scenario.impl.WaitstateExecutable;
import org.camunda.bpm.scenario.impl.util.Api;
import org.camunda.bpm.scenario.impl.util.IdComparator;
import org.camunda.bpm.scenario.impl.util.Log;
import org.camunda.bpm.scenario.impl.waitstate.CallActivityExecutable;
import org.camunda.bpm.scenario.run.ProcessRunner;
import org.camunda.bpm.scenario.run.ProcessStarter;

public class ProcessRunnerImpl
extends AbstractRunner
implements ProcessRunner.ExecutableRunner.StartingByKey,
ProcessRunner.ExecutableRunner.StartingByMessage,
ProcessRunner.StartableRunner,
ProcessRunner.ExecutableRunner.StartingByStarter,
ProcessRunner {
    private String startMessage;
    private ProcessStarter processStarter;
    private Map<String, Object> variables;
    private Map<String, Boolean> fromActivityIds = new HashMap<String, Boolean>();
    private Set<String> executed = new HashSet<String>();
    private Set<String> started = new HashSet<String>();
    private Set<String> finished = new HashSet<String>();
    ScenarioImpl scenarioExecutor;
    ProcessScenario scenario;
    ProcessInstance processInstance;
    String processDefinitionKey;

    public ProcessRunnerImpl(ScenarioImpl scenarioExecutor, ProcessScenario scenario) {
        this.scenarioExecutor = scenarioExecutor;
        this.scenario = scenario;
    }

    @Override
    public ProcessRunner.ExecutableRunner.StartingByStarter startBy(ProcessStarter scenarioStarter) {
        this.processStarter = scenarioStarter;
        return this;
    }

    @Override
    public ProcessRunner.ExecutableRunner.StartingByKey startByKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public ProcessRunner.ExecutableRunner.StartingByKey startByKey(String processDefinitionKey, Map<String, Object> variables) {
        this.processDefinitionKey = processDefinitionKey;
        this.variables = variables;
        return this;
    }

    @Override
    public ProcessRunner.ExecutableRunner.StartingByMessage startByMessage(String messageName) {
        this.startMessage = messageName;
        return this;
    }

    @Override
    public ProcessRunner.ExecutableRunner.StartingByMessage startByMessage(String messageName, Map<String, Object> variables) {
        this.startMessage = messageName;
        this.variables = variables;
        return this;
    }

    @Override
    public ProcessRunner.ExecutableRunner.StartingByKey fromBefore(String activityId) {
        Api.feature(RuntimeService.class.getName(), "createProcessInstanceByKey", String.class).fail("Outdated Camunda BPM version used will not allow to start process instances at explicitely selected activity IDs");
        this.fromActivityIds.put(activityId, true);
        return this;
    }

    @Override
    public ProcessRunner.ExecutableRunner.StartingByKey fromAfter(String activityId) {
        Api.feature(RuntimeService.class.getName(), "createProcessInstanceByKey", String.class).fail("Outdated Camunda BPM version used will not allow to start process instances at explicitely selected activity IDs");
        this.fromActivityIds.put(activityId, false);
        return this;
    }

    @Override
    public ProcessRunner.StartableRunner run(ProcessScenario scenario) {
        this.scenarioExecutor.runners.add(new ProcessRunnerImpl(this.scenarioExecutor, scenario));
        return this.scenarioExecutor.toBeStartedBy();
    }

    @Override
    public ProcessRunner.ExecutableRunner engine(ProcessEngine processEngine) {
        this.scenarioExecutor.init(processEngine);
        return this;
    }

    @Override
    public Scenario execute() {
        return this.scenarioExecutor.execute();
    }

    public ProcessEngine engine() {
        return this.scenarioExecutor.processEngine;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void running(CallActivityExecutable waitstate) {
        this.scenarioExecutor = waitstate.runner.scenarioExecutor;
        this.scenarioExecutor.runners.add(this);
        this.processInstance = waitstate;
        this.processDefinitionKey = ((ProcessDefinition)this.engine().getRepositoryService().createProcessDefinitionQuery().processDefinitionId(this.processInstance.getProcessDefinitionId()).singleResult()).getKey();
        this.setExecuted();
    }

    public ProcessInstance run() {
        if (this.processInstance == null) {
            if (this.processDefinitionKey != null) {
                this.processStarter = new ProcessStarter(){

                    @Override
                    public ProcessInstance start() {
                        if (ProcessRunnerImpl.this.fromActivityIds.isEmpty()) {
                            return ProcessRunnerImpl.this.scenarioExecutor.processEngine.getRuntimeService().startProcessInstanceByKey(ProcessRunnerImpl.this.processDefinitionKey, ProcessRunnerImpl.this.variables);
                        }
                        ProcessInstantiationBuilder builder = ProcessRunnerImpl.this.scenarioExecutor.processEngine.getRuntimeService().createProcessInstanceByKey(ProcessRunnerImpl.this.processDefinitionKey);
                        for (String activityId : ProcessRunnerImpl.this.fromActivityIds.keySet()) {
                            Boolean from = (Boolean)ProcessRunnerImpl.this.fromActivityIds.get(activityId);
                            if (from.booleanValue()) {
                                builder.startBeforeActivity(activityId);
                                continue;
                            }
                            builder.startAfterActivity(activityId);
                        }
                        if (ProcessRunnerImpl.this.variables != null) {
                            builder.setVariables(ProcessRunnerImpl.this.variables);
                        }
                        return builder.execute();
                    }
                };
            } else if (this.startMessage != null) {
                this.processStarter = new ProcessStarter(){

                    @Override
                    public ProcessInstance start() {
                        return ProcessRunnerImpl.this.scenarioExecutor.processEngine.getRuntimeService().startProcessInstanceByMessage(ProcessRunnerImpl.this.startMessage, ProcessRunnerImpl.this.variables);
                    }
                };
            }
        }
        if (this.processInstance == null) {
            this.processInstance = this.processStarter.start();
            if (this.processDefinitionKey == null) {
                this.processDefinitionKey = ((ProcessDefinition)this.engine().getRepositoryService().createProcessDefinitionQuery().processDefinitionId(this.processInstance.getProcessDefinitionId()).singleResult()).getKey();
            }
            this.setExecuted();
        }
        return this.processInstance;
    }

    @Override
    public List<Executable> next() {
        this.run();
        ArrayList<Executable> executables = new ArrayList<Executable>();
        executables.addAll(Executable.Deferreds.next(this));
        executables.addAll(Executable.Waitstates.next(this));
        executables.addAll(Executable.Jobs.next(this));
        if (executables.isEmpty()) {
            this.setExecuted();
        }
        return Executable.Helpers.first(executables);
    }

    public void setExecuted() {
        boolean supportsCanceled = Api.feature(HistoricActivityInstance.class.getName(), "isCanceled", new Class[0]).warn("Outdated Camunda BPM version used will not allow to use '" + ProcessScenario.class.getName().replace('$', '.') + ".hasCanceled(String activityId)' and '.hasCompleted(String activityId)' methods.");
        List instances = this.scenarioExecutor.processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(this.processInstance.getId()).list();
        Collections.sort(instances, new Comparator<HistoricActivityInstance>(){
            IdComparator idComparator = new IdComparator();

            @Override
            public int compare(HistoricActivityInstance instance1, HistoricActivityInstance instance2) {
                return this.idComparator.compare(instance1.getId(), instance2.getId());
            }
        });
        for (HistoricActivityInstance instance : instances) {
            if (!this.started.contains(instance.getId())) {
                Log.Action.Started.log(instance.getActivityType(), instance.getActivityName(), instance.getActivityId(), this.processDefinitionKey, instance.getProcessInstanceId(), null, null);
                this.scenario.hasStarted(instance.getActivityId());
                this.started.add(instance.getId());
            }
            if (instance.getEndTime() == null || this.finished.contains(instance.getId())) continue;
            this.scenario.hasFinished(instance.getActivityId());
            if (supportsCanceled) {
                if (instance.isCanceled()) {
                    Log.Action.Canceled.log(instance.getActivityType(), instance.getActivityName(), instance.getActivityId(), this.processDefinitionKey, instance.getProcessInstanceId(), null, null);
                    this.scenario.hasCanceled(instance.getActivityId());
                } else {
                    Log.Action.Completed.log(instance.getActivityType(), instance.getActivityName(), instance.getActivityId(), this.processDefinitionKey, instance.getProcessInstanceId(), null, null);
                    this.scenario.hasCompleted(instance.getActivityId());
                }
            } else {
                Log.Action.Finished.log(instance.getActivityType(), instance.getActivityName(), instance.getActivityId(), this.processDefinitionKey, instance.getProcessInstanceId(), null, null);
            }
            this.finished.add(instance.getId());
        }
    }

    public void setExecuted(WaitstateExecutable waitstate) {
        this.executed.add(waitstate.historicDelegate.getId());
        this.setExecuted();
    }

    public boolean isExecuted(HistoricActivityInstance instance) {
        return this.executed.contains(instance.getId());
    }
}

