/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.scenario.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.scenario.ProcessScenario;
import org.camunda.bpm.scenario.Scenario;
import org.camunda.bpm.scenario.impl.AbstractRunner;
import org.camunda.bpm.scenario.impl.Executable;
import org.camunda.bpm.scenario.impl.ProcessRunnerImpl;
import org.camunda.bpm.scenario.impl.util.Time;
import org.camunda.bpm.scenario.run.ProcessRunner;

public class ScenarioImpl
extends Scenario {
    private boolean executed;
    ProcessEngine processEngine;
    List<AbstractRunner> runners = new ArrayList<AbstractRunner>();
    List<BpmnModelInstance> mockedCallActivities = new ArrayList<BpmnModelInstance>();
    private String deploymentId;

    public ScenarioImpl(ProcessScenario scenario) {
        this.runners.add(new ProcessRunnerImpl(this, scenario));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Scenario execute() {
        try {
            List<Executable> executables;
            this.init();
            Time.init();
            do {
                executables = new ArrayList<Executable>();
                for (AbstractRunner runner : this.runners) {
                    executables.addAll(runner.next());
                }
                if ((executables = Executable.Helpers.first(executables)).isEmpty()) continue;
                executables.get(0).execute();
            } while (!executables.isEmpty());
        }
        finally {
            Time.reset();
            this.cleanup();
        }
        return this;
    }

    @Override
    public ProcessInstance instance(ProcessScenario scenario) {
        List<ProcessInstance> instances = this.instances(scenario);
        if (instances.size() > 1) {
            throw new IllegalStateException("Scenario executed more than a single process instance based on the scenario provided as a parameter");
        }
        return instances.size() == 1 ? instances.get(0) : null;
    }

    @Override
    public List<ProcessInstance> instances(ProcessScenario scenario) {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (AbstractRunner runner : this.runners) {
            if (!(runner instanceof ProcessRunnerImpl)) continue;
            ProcessRunnerImpl processRunner = (ProcessRunnerImpl)runner;
            if (processRunner.scenario != scenario) continue;
            instances.add(processRunner.processInstance);
        }
        return instances;
    }

    protected void init() {
        if (this.executed) {
            throw new IllegalStateException("Scenarios may use execute() just once per Scenario.run(). Please create a new Scenario.run().");
        }
        this.executed = true;
        if (this.processEngine == null) {
            Map processEngines = ProcessEngines.getProcessEngines();
            if (processEngines.size() == 1) {
                this.init((ProcessEngine)processEngines.values().iterator().next());
            } else {
                String message = processEngines.size() == 0 ? "No ProcessEngine found to be registered with " + ProcessEngines.class.getSimpleName() + "!" : String.format(processEngines.size() + " ProcessEngines initialized. Explicitely initialise engine by calling " + ScenarioImpl.class.getSimpleName() + "(scenario, engine)", new Object[0]);
                throw new IllegalStateException(message);
            }
        }
        if (!this.mockedCallActivities.isEmpty()) {
            DeploymentBuilder deployment = this.processEngine.getRepositoryService().createDeployment();
            for (BpmnModelInstance mockedCallActivity : this.mockedCallActivities) {
                boolean exists;
                String processDefinitionKey = ((Process)mockedCallActivity.getDefinitions().getChildElementsByType(Process.class).iterator().next()).getId();
                boolean bl = exists = !this.processEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).list().isEmpty();
                if (exists) {
                    throw new AssertionError((Object)("Process '" + processDefinitionKey + "' declared to be mocked, but it is already deployed. Please remove from your list of explicit deployments."));
                }
                deployment.addModelInstance("mockedCallActivity.bpmn", mockedCallActivity);
            }
            this.deploymentId = deployment.deploy().getId();
        }
    }

    protected void init(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    protected void cleanup() {
        if (this.deploymentId != null) {
            this.processEngine.getRepositoryService().deleteDeployment(this.deploymentId, true);
        }
    }

    public ProcessRunner.StartableRunner toBeStartedBy() {
        return (ProcessRunner.StartableRunner)((Object)this.runners.get(this.runners.size() - 1));
    }
}

