/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.graphql.resolvers;

import graphql.kickstart.tools.GraphQLMutationResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Mutation
implements GraphQLMutationResolver {
    private static final Logger LOGGER = Logger.getLogger(Mutation.class.getName());
    @Autowired
    ProcessEngine processEngine;
    @Autowired
    TaskService taskService;
    @Autowired
    RuntimeService runtimeService;

    public Task setAssignee(String taskEntityId, String assignee) {
        Task task = (Task)this.taskService.createTaskQuery().taskId(taskEntityId).singleResult();
        task.setAssignee(assignee);
        this.taskService.saveTask(task);
        return task;
    }

    public ProcessInstance createProcessInstance(String processDefintionKey, ArrayList<LinkedHashMap> variables) {
        return this.runtimeService.startProcessInstanceByKey(processDefintionKey, this.getVariablesMap(variables));
    }

    public Task claimTask(String taskId, String userId) {
        Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        this.taskService.claim(taskId, userId);
        return (Task)this.taskService.createTaskQuery().initializeFormKeys().taskId(taskId).singleResult();
    }

    public ProcessInstance completeTask(String taskId, ArrayList<LinkedHashMap> variables) {
        Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        String piId = task.getProcessInstanceId();
        if (variables != null) {
            this.taskService.complete(taskId, this.getVariablesMap(variables));
        } else {
            this.taskService.complete(taskId);
        }
        if (piId != null) {
            return (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(piId).singleResult();
        }
        return null;
    }

    public ProcessInstance startProcessInstanceByKey(String key) {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(key);
        return (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).singleResult();
    }

    public ProcessInstance startProcessInstanceByMessage(String message, String businesskey, ArrayList<LinkedHashMap> variables) {
        return this.runtimeService.startProcessInstanceByMessage(message, businesskey, this.getVariablesMap(variables));
    }

    private Map<String, Object> getVariablesMap(ArrayList<LinkedHashMap> variables) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        block16: for (LinkedHashMap i : variables) {
            switch (i.get("valueType").toString()) {
                case "STRING": {
                    map.put(i.get("key").toString(), i.get("value"));
                    continue block16;
                }
                case "INT": {
                    map.put(i.get("key").toString(), Integer.parseInt(i.get("value").toString()));
                    continue block16;
                }
                case "LONG": {
                    map.put(i.get("key").toString(), Long.parseLong(i.get("value").toString()));
                    continue block16;
                }
                case "FLOAT": {
                    map.put(i.get("key").toString(), Float.valueOf(Float.parseFloat(i.get("value").toString())));
                    continue block16;
                }
                case "DOUBLE": {
                    map.put(i.get("key").toString(), Double.parseDouble(i.get("value").toString()));
                    continue block16;
                }
                case "BOOLEAN": {
                    map.put(i.get("key").toString(), Boolean.parseBoolean(i.get("value").toString()));
                    continue block16;
                }
            }
            map.put(i.get("key").toString(), i.get("value"));
        }
        return map;
    }
}

