/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.graphql.resolvers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.application.ProcessApplicationContext;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.application.ProcessApplicationManager;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.impl.value.ObjectValueImpl;
import org.camunda.bpm.engine.variable.type.SerializableValueType;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.extension.graphql.types.KeyValuePair;
import org.camunda.bpm.extension.graphql.types.ValueTypeEnum;
import org.camunda.spin.Spin;

public class Util {
    private static final Logger LOGGER = Logger.getLogger(Util.class.getName());

    public static void switchContext(RepositoryService repositoryService, String pdid, ProcessEngineConfigurationImpl processEngineConfiguration) {
        ProcessDefinition processDefinition = repositoryService.getProcessDefinition(pdid);
        String deploymentId = processDefinition.getDeploymentId();
        ProcessApplicationManager processApplicationManager = processEngineConfiguration.getProcessApplicationManager();
        ProcessApplicationReference targetProcessApplication = processApplicationManager.getProcessApplicationForDeployment(deploymentId);
        if (targetProcessApplication != null) {
            String processApplicationName = targetProcessApplication.getName();
            ProcessApplicationContext.setCurrentProcessApplication((String)processApplicationName);
        }
    }

    public static List<KeyValuePair> getKeyValuePairs(VariableMap variableMap) {
        ArrayList<KeyValuePair> keyValuePairs = new ArrayList<KeyValuePair>();
        for (Map.Entry i : variableMap.entrySet()) {
            Object objValue = i.getValue();
            String key = (String)i.getKey();
            TypedValue typedValue = variableMap.getValueTyped(key);
            if (objValue != null) {
                ObjectValueImpl objectValueImpl;
                String value = typedValue.getType() == SerializableValueType.OBJECT ? ((objectValueImpl = (ObjectValueImpl)typedValue).getSerializationDataFormat().equals(Variables.SerializationDataFormats.JSON.toString()) ? Spin.JSON((Object)key).toString() : typedValue.getValue().toString()) : objValue.toString();
                KeyValuePair keyValuePair = new KeyValuePair(key, value, ValueTypeEnum.from(variableMap.getValueTyped(key).getType()));
                keyValuePairs.add(keyValuePair);
                continue;
            }
            LOGGER.info("objValue is null: " + key);
        }
        return keyValuePairs;
    }
}

