/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.graphql.types;

import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DateTypeScalar {
    private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    @Bean
    public GraphQLScalarType date() {
        return GraphQLScalarType.newScalar().name("Date").description("Date").coercing((Coercing)new Coercing<Date, String>(){

            public String serialize(Object date) throws CoercingSerializeException {
                if (date == null) {
                    return "";
                }
                return new SimpleDateFormat(DateTypeScalar.DATE_FORMAT_PATTERN).format((Date)date);
            }

            public Date parseValue(Object date) throws CoercingParseValueException {
                if (date == null) {
                    return null;
                }
                try {
                    return new SimpleDateFormat(DateTypeScalar.DATE_FORMAT_PATTERN).parse(date.toString());
                }
                catch (ParseException e) {
                    return null;
                }
            }

            public Date parseLiteral(Object o) throws CoercingParseLiteralException {
                return this.parseValue(o);
            }
        }).build();
    }
}

