/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.http.protocol;

import java.io.IOException;
import keycloakjar.org.apache.http.HttpException;
import keycloakjar.org.apache.http.HttpRequest;
import keycloakjar.org.apache.http.HttpRequestInterceptor;
import keycloakjar.org.apache.http.annotation.Contract;
import keycloakjar.org.apache.http.annotation.ThreadingBehavior;
import keycloakjar.org.apache.http.params.HttpParams;
import keycloakjar.org.apache.http.protocol.HttpContext;
import keycloakjar.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s = (String)params.getParameter("http.useragent");
            }
            if (s == null) {
                s = this.userAgent;
            }
            if (s != null) {
                request.addHeader("User-Agent", s);
            }
        }
    }
}

