/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.codec;

import java.util.Map;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.codec.AbstractDecoder;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferUtils;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.MimeType;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractDataBufferDecoder<T>
extends AbstractDecoder<T> {
    private int maxInMemorySize = 262144;

    protected AbstractDataBufferDecoder(MimeType ... supportedMimeTypes) {
        super(supportedMimeTypes);
    }

    public void setMaxInMemorySize(int byteCount) {
        this.maxInMemorySize = byteCount;
    }

    public int getMaxInMemorySize() {
        return this.maxInMemorySize;
    }

    @Override
    public Flux<T> decode(Publisher<DataBuffer> input, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Flux.from(input).map(buffer -> this.decodeDataBuffer((DataBuffer)buffer, elementType, mimeType, hints));
    }

    @Override
    public Mono<T> decodeToMono(Publisher<DataBuffer> input, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return DataBufferUtils.join(input, this.maxInMemorySize).map(buffer -> this.decodeDataBuffer((DataBuffer)buffer, elementType, mimeType, hints));
    }

    @Deprecated
    protected T decodeDataBuffer(DataBuffer buffer, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return this.decode(buffer, elementType, mimeType, hints);
    }
}

