/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.context.support;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import keycloakjar.org.springframework.core.env.MutablePropertySources;
import keycloakjar.org.springframework.core.env.PropertySource;
import keycloakjar.org.springframework.core.env.StandardEnvironment;
import keycloakjar.org.springframework.jndi.JndiLocatorDelegate;
import keycloakjar.org.springframework.jndi.JndiPropertySource;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.web.context.ConfigurableWebEnvironment;
import keycloakjar.org.springframework.web.context.support.WebApplicationContextUtils;

public class StandardServletEnvironment
extends StandardEnvironment
implements ConfigurableWebEnvironment {
    public static final String SERVLET_CONTEXT_PROPERTY_SOURCE_NAME = "servletContextInitParams";
    public static final String SERVLET_CONFIG_PROPERTY_SOURCE_NAME = "servletConfigInitParams";
    public static final String JNDI_PROPERTY_SOURCE_NAME = "jndiProperties";

    @Override
    protected void customizePropertySources(MutablePropertySources propertySources) {
        propertySources.addLast(new PropertySource.StubPropertySource(SERVLET_CONFIG_PROPERTY_SOURCE_NAME));
        propertySources.addLast(new PropertySource.StubPropertySource(SERVLET_CONTEXT_PROPERTY_SOURCE_NAME));
        if (JndiLocatorDelegate.isDefaultJndiEnvironmentAvailable()) {
            propertySources.addLast((PropertySource<?>)new JndiPropertySource(JNDI_PROPERTY_SOURCE_NAME));
        }
        super.customizePropertySources(propertySources);
    }

    @Override
    public void initPropertySources(@Nullable ServletContext servletContext, @Nullable ServletConfig servletConfig) {
        WebApplicationContextUtils.initServletPropertySources(this.getPropertySources(), servletContext, servletConfig);
    }
}

