/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.web.cors.CorsConfiguration;
import keycloakjar.org.springframework.web.cors.CorsConfigurationSource;
import keycloakjar.org.springframework.web.cors.CorsProcessor;
import keycloakjar.org.springframework.web.cors.CorsUtils;
import keycloakjar.org.springframework.web.cors.DefaultCorsProcessor;
import keycloakjar.org.springframework.web.filter.OncePerRequestFilter;

public class CorsFilter
extends OncePerRequestFilter {
    private final CorsConfigurationSource configSource;
    private CorsProcessor processor = new DefaultCorsProcessor();

    public CorsFilter(CorsConfigurationSource configSource) {
        Assert.notNull((Object)configSource, "CorsConfigurationSource must not be null");
        this.configSource = configSource;
    }

    public void setCorsProcessor(CorsProcessor processor) {
        Assert.notNull((Object)processor, "CorsProcessor must not be null");
        this.processor = processor;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        CorsConfiguration corsConfiguration = this.configSource.getCorsConfiguration(request);
        boolean isValid = this.processor.processRequest(corsConfiguration, request, response);
        if (!isValid || CorsUtils.isPreFlightRequest(request)) {
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

