/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.DigestUtils;
import keycloakjar.org.springframework.web.filter.OncePerRequestFilter;
import keycloakjar.org.springframework.web.util.ContentCachingResponseWrapper;
import keycloakjar.org.springframework.web.util.WebUtils;

public class ShallowEtagHeaderFilter
extends OncePerRequestFilter {
    private static final String DIRECTIVE_NO_STORE = "no-store";
    private static final String STREAMING_ATTRIBUTE = ShallowEtagHeaderFilter.class.getName() + ".STREAMING";
    private boolean writeWeakETag = false;

    public void setWriteWeakETag(boolean writeWeakETag) {
        this.writeWeakETag = writeWeakETag;
    }

    public boolean isWriteWeakETag() {
        return this.writeWeakETag;
    }

    @Override
    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Object responseToUse = response;
        if (!this.isAsyncDispatch(request) && !(response instanceof ContentCachingResponseWrapper)) {
            responseToUse = new HttpStreamingAwareContentCachingResponseWrapper(response, request);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)responseToUse);
        if (!this.isAsyncStarted(request) && !ShallowEtagHeaderFilter.isContentCachingDisabled(request)) {
            this.updateResponse(request, (HttpServletResponse)responseToUse);
        }
    }

    private void updateResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ContentCachingResponseWrapper responseWrapper = WebUtils.getNativeResponse((ServletResponse)response, ContentCachingResponseWrapper.class);
        Assert.notNull((Object)responseWrapper, "ContentCachingResponseWrapper not found");
        HttpServletResponse rawResponse = (HttpServletResponse)responseWrapper.getResponse();
        int statusCode = responseWrapper.getStatus();
        if (rawResponse.isCommitted()) {
            responseWrapper.copyBodyToResponse();
        } else if (this.isEligibleForEtag(request, (HttpServletResponse)responseWrapper, statusCode, responseWrapper.getContentInputStream())) {
            String responseETag = this.generateETagHeaderValue(responseWrapper.getContentInputStream(), this.writeWeakETag);
            rawResponse.setHeader("ETag", responseETag);
            String requestETag = request.getHeader("If-None-Match");
            if (requestETag != null && ("*".equals(requestETag) || this.compareETagHeaderValue(requestETag, responseETag))) {
                rawResponse.setStatus(304);
            } else {
                responseWrapper.copyBodyToResponse();
            }
        } else {
            responseWrapper.copyBodyToResponse();
        }
    }

    protected boolean isEligibleForEtag(HttpServletRequest request, HttpServletResponse response, int responseStatusCode, InputStream inputStream) {
        String method = request.getMethod();
        if (responseStatusCode >= 200 && responseStatusCode < 300 && HttpMethod.GET.matches(method)) {
            String cacheControl = response.getHeader("Cache-Control");
            return cacheControl == null || !cacheControl.contains(DIRECTIVE_NO_STORE);
        }
        return false;
    }

    protected String generateETagHeaderValue(InputStream inputStream, boolean isWeak) throws IOException {
        StringBuilder builder = new StringBuilder(37);
        if (isWeak) {
            builder.append("W/");
        }
        builder.append("\"0");
        DigestUtils.appendMd5DigestAsHex(inputStream, builder);
        builder.append('\"');
        return builder.toString();
    }

    private boolean compareETagHeaderValue(String requestETag, String responseETag) {
        if (requestETag.startsWith("W/")) {
            requestETag = requestETag.substring(2);
        }
        if (responseETag.startsWith("W/")) {
            responseETag = responseETag.substring(2);
        }
        return requestETag.equals(responseETag);
    }

    public static void disableContentCaching(ServletRequest request) {
        Assert.notNull((Object)request, "ServletRequest must not be null");
        request.setAttribute(STREAMING_ATTRIBUTE, (Object)true);
    }

    private static boolean isContentCachingDisabled(HttpServletRequest request) {
        return request.getAttribute(STREAMING_ATTRIBUTE) != null;
    }

    private static class HttpStreamingAwareContentCachingResponseWrapper
    extends ContentCachingResponseWrapper {
        private final HttpServletRequest request;

        public HttpStreamingAwareContentCachingResponseWrapper(HttpServletResponse response, HttpServletRequest request) {
            super(response);
            this.request = request;
        }

        @Override
        public ServletOutputStream getOutputStream() throws IOException {
            return this.useRawResponse() ? this.getResponse().getOutputStream() : super.getOutputStream();
        }

        @Override
        public PrintWriter getWriter() throws IOException {
            return this.useRawResponse() ? this.getResponse().getWriter() : super.getWriter();
        }

        private boolean useRawResponse() {
            return ShallowEtagHeaderFilter.isContentCachingDisabled(this.request);
        }
    }
}

