/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak;

import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import keycloakjar.org.apache.http.config.Registry;
import keycloakjar.org.apache.http.config.RegistryBuilder;
import keycloakjar.org.apache.http.conn.socket.ConnectionSocketFactory;
import keycloakjar.org.apache.http.conn.ssl.NoopHostnameVerifier;
import keycloakjar.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import keycloakjar.org.apache.http.impl.client.HttpClientBuilder;
import keycloakjar.org.apache.http.impl.client.LaxRedirectStrategy;
import keycloakjar.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import keycloakjar.org.apache.http.ssl.SSLContexts;
import keycloakjar.org.apache.http.ssl.TrustStrategy;
import keycloakjar.org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import keycloakjar.org.springframework.http.converter.StringHttpMessageConverter;
import keycloakjar.org.springframework.web.client.RestTemplate;
import org.camunda.bpm.engine.impl.identity.IdentityProviderException;
import org.camunda.bpm.engine.impl.identity.ReadOnlyIdentityProvider;
import org.camunda.bpm.engine.impl.interceptor.Session;
import org.camunda.bpm.engine.impl.interceptor.SessionFactory;
import org.camunda.bpm.extension.keycloak.KeycloakConfiguration;
import org.camunda.bpm.extension.keycloak.KeycloakContextProvider;
import org.camunda.bpm.extension.keycloak.KeycloakIdentityProviderSession;

public class KeycloakIdentityProviderFactory
implements SessionFactory {
    protected KeycloakConfiguration keycloakConfiguration;
    protected KeycloakContextProvider keycloakContextProvider;
    protected RestTemplate restTemplate = new RestTemplate();

    public KeycloakIdentityProviderFactory(KeycloakConfiguration keycloakConfiguration) {
        this.keycloakConfiguration = keycloakConfiguration;
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        HttpClientBuilder httpClient = HttpClientBuilder.create().setRedirectStrategy(new LaxRedirectStrategy());
        if (keycloakConfiguration.isDisableSSLCertificateValidation()) {
            try {
                TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
                NoopHostnameVerifier allowAllHosts = new NoopHostnameVerifier();
                Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.create().register("https", new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)allowAllHosts)).build();
                PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
                connectionManager.setMaxTotal(keycloakConfiguration.getMaxHttpConnections());
                httpClient.setConnectionManager(connectionManager);
            }
            catch (GeneralSecurityException e) {
                throw new IdentityProviderException("Disabling SSL certificate validation failed", (Throwable)e);
            }
        } else {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setMaxTotal(keycloakConfiguration.getMaxHttpConnections());
            httpClient.setConnectionManager(connectionManager);
        }
        factory.setHttpClient(httpClient.build());
        this.restTemplate.setRequestFactory(factory);
        for (int i = 0; i < this.restTemplate.getMessageConverters().size(); ++i) {
            if (!(this.restTemplate.getMessageConverters().get(i) instanceof StringHttpMessageConverter)) continue;
            this.restTemplate.getMessageConverters().set(i, new StringHttpMessageConverter(Charset.forName(keycloakConfiguration.getCharset())));
            break;
        }
        this.keycloakContextProvider = new KeycloakContextProvider(keycloakConfiguration, this.restTemplate);
    }

    public Class<?> getSessionType() {
        return ReadOnlyIdentityProvider.class;
    }

    public Session openSession() {
        return new KeycloakIdentityProviderSession(this.keycloakConfiguration, this.restTemplate, this.keycloakContextProvider);
    }
}

