/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.codec;

import java.util.List;
import java.util.Map;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.codec.CodecException;
import keycloakjar.org.springframework.core.codec.DecodingException;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.MimeType;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public interface Decoder<T> {
    public boolean canDecode(ResolvableType var1, @Nullable MimeType var2);

    public Flux<T> decode(Publisher<DataBuffer> var1, ResolvableType var2, @Nullable MimeType var3, @Nullable Map<String, Object> var4);

    public Mono<T> decodeToMono(Publisher<DataBuffer> var1, ResolvableType var2, @Nullable MimeType var3, @Nullable Map<String, Object> var4);

    default public T decode(DataBuffer buffer, ResolvableType targetType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) throws DecodingException {
        MonoProcessor processor = MonoProcessor.create();
        this.decodeToMono((Publisher<DataBuffer>)Mono.just((Object)buffer), targetType, mimeType, hints).subscribeWith((Subscriber)processor);
        Assert.state(processor.isTerminated(), "DataBuffer decoding should have completed.");
        Throwable ex = processor.getError();
        if (ex != null) {
            throw ex instanceof CodecException ? (CodecException)ex : new DecodingException("Failed to decode: " + ex.getMessage(), ex);
        }
        return (T)processor.peek();
    }

    public List<MimeType> getDecodableMimeTypes();
}

