/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.log;

import java.util.ArrayList;
import java.util.Collections;
import keycloakjar.org.apache.commons.logging.Log;
import keycloakjar.org.apache.commons.logging.LogFactory;
import keycloakjar.org.springframework.core.log.CompositeLog;

public final class LogDelegateFactory {
    private LogDelegateFactory() {
    }

    public static Log getCompositeLog(Log primaryLogger, Log secondaryLogger, Log ... tertiaryLoggers) {
        ArrayList<Log> loggers = new ArrayList<Log>(2 + tertiaryLoggers.length);
        loggers.add(primaryLogger);
        loggers.add(secondaryLogger);
        Collections.addAll(loggers, tertiaryLoggers);
        return new CompositeLog(loggers);
    }

    public static Log getHiddenLog(Class<?> clazz) {
        return LogFactory.getLog("_" + clazz.getName());
    }
}

