/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.log;

import java.util.function.Function;
import keycloakjar.org.apache.commons.logging.Log;
import keycloakjar.org.springframework.lang.Nullable;

public abstract class LogFormatUtils {
    public static String formatValue(@Nullable Object value, boolean limitLength) {
        String str;
        if (value == null) {
            return "";
        }
        if (value instanceof CharSequence) {
            str = "\"" + value + "\"";
        } else {
            try {
                str = value.toString();
            }
            catch (Throwable ex) {
                str = ex.toString();
            }
        }
        return limitLength && str.length() > 100 ? str.substring(0, 100) + " (truncated)..." : str;
    }

    public static void traceDebug(Log logger, Function<Boolean, String> messageFactory) {
        if (logger.isDebugEnabled()) {
            boolean traceEnabled = logger.isTraceEnabled();
            String logMessage = messageFactory.apply(traceEnabled);
            if (traceEnabled) {
                logger.trace(logMessage);
            } else {
                logger.debug(logMessage);
            }
        }
    }
}

