/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.type.classreading;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import keycloakjar.org.springframework.asm.AnnotationVisitor;
import keycloakjar.org.springframework.asm.MethodVisitor;
import keycloakjar.org.springframework.asm.Type;
import keycloakjar.org.springframework.core.annotation.MergedAnnotation;
import keycloakjar.org.springframework.core.annotation.MergedAnnotations;
import keycloakjar.org.springframework.core.type.classreading.MergedAnnotationReadingVisitor;
import keycloakjar.org.springframework.core.type.classreading.SimpleMethodMetadata;
import keycloakjar.org.springframework.lang.Nullable;

final class SimpleMethodMetadataReadingVisitor
extends MethodVisitor {
    @Nullable
    private final ClassLoader classLoader;
    private final String declaringClassName;
    private final int access;
    private final String name;
    private final String descriptor;
    private final List<MergedAnnotation<?>> annotations = new ArrayList(4);
    private final Consumer<SimpleMethodMetadata> consumer;
    @Nullable
    private Source source;

    SimpleMethodMetadataReadingVisitor(@Nullable ClassLoader classLoader, String declaringClassName, int access, String name, String descriptor, Consumer<SimpleMethodMetadata> consumer) {
        super(458752);
        this.classLoader = classLoader;
        this.declaringClassName = declaringClassName;
        this.access = access;
        this.name = name;
        this.descriptor = descriptor;
        this.consumer = consumer;
    }

    @Override
    @Nullable
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        return MergedAnnotationReadingVisitor.get(this.classLoader, this::getSource, descriptor, visible, this.annotations::add);
    }

    @Override
    public void visitEnd() {
        if (!this.annotations.isEmpty()) {
            String returnTypeName = Type.getReturnType(this.descriptor).getClassName();
            MergedAnnotations annotations = MergedAnnotations.of(this.annotations);
            SimpleMethodMetadata metadata = new SimpleMethodMetadata(this.name, this.access, this.declaringClassName, returnTypeName, annotations);
            this.consumer.accept(metadata);
        }
    }

    private Object getSource() {
        Source source = this.source;
        if (source == null) {
            this.source = source = new Source(this.declaringClassName, this.name, this.descriptor);
        }
        return source;
    }

    static final class Source {
        private final String declaringClassName;
        private final String name;
        private final String descriptor;
        @Nullable
        private String toStringValue;

        Source(String declaringClassName, String name, String descriptor) {
            this.declaringClassName = declaringClassName;
            this.name = name;
            this.descriptor = descriptor;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.declaringClassName.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.descriptor.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Source otherSource = (Source)other;
            return this.declaringClassName.equals(otherSource.declaringClassName) && this.name.equals(otherSource.name) && this.descriptor.equals(otherSource.descriptor);
        }

        public String toString() {
            String value = this.toStringValue;
            if (value == null) {
                StringBuilder builder = new StringBuilder();
                builder.append(this.declaringClassName);
                builder.append(".");
                builder.append(this.name);
                Type[] argumentTypes = Type.getArgumentTypes(this.descriptor);
                builder.append("(");
                for (Type type : argumentTypes) {
                    builder.append(type.getClassName());
                }
                builder.append(")");
                this.toStringValue = value = builder.toString();
            }
            return value;
        }
    }
}

