/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.remoting.httpinvoker;

import java.io.InvalidClassException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import keycloakjar.org.springframework.aop.support.AopUtils;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.remoting.RemoteAccessException;
import keycloakjar.org.springframework.remoting.RemoteConnectFailureException;
import keycloakjar.org.springframework.remoting.RemoteInvocationFailureException;
import keycloakjar.org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;
import keycloakjar.org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;
import keycloakjar.org.springframework.remoting.httpinvoker.SimpleHttpInvokerRequestExecutor;
import keycloakjar.org.springframework.remoting.support.RemoteInvocation;
import keycloakjar.org.springframework.remoting.support.RemoteInvocationBasedAccessor;
import keycloakjar.org.springframework.remoting.support.RemoteInvocationResult;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class HttpInvokerClientInterceptor
extends RemoteInvocationBasedAccessor
implements MethodInterceptor,
HttpInvokerClientConfiguration {
    @Nullable
    private String codebaseUrl;
    @Nullable
    private HttpInvokerRequestExecutor httpInvokerRequestExecutor;

    public void setCodebaseUrl(@Nullable String codebaseUrl) {
        this.codebaseUrl = codebaseUrl;
    }

    @Override
    @Nullable
    public String getCodebaseUrl() {
        return this.codebaseUrl;
    }

    public void setHttpInvokerRequestExecutor(HttpInvokerRequestExecutor httpInvokerRequestExecutor) {
        this.httpInvokerRequestExecutor = httpInvokerRequestExecutor;
    }

    public HttpInvokerRequestExecutor getHttpInvokerRequestExecutor() {
        if (this.httpInvokerRequestExecutor == null) {
            SimpleHttpInvokerRequestExecutor executor = new SimpleHttpInvokerRequestExecutor();
            executor.setBeanClassLoader(this.getBeanClassLoader());
            this.httpInvokerRequestExecutor = executor;
        }
        return this.httpInvokerRequestExecutor;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.getHttpInvokerRequestExecutor();
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        RemoteInvocationResult result;
        if (AopUtils.isToStringMethod((Method)methodInvocation.getMethod())) {
            return "HTTP invoker proxy for service URL [" + this.getServiceUrl() + "]";
        }
        RemoteInvocation invocation = this.createRemoteInvocation(methodInvocation);
        try {
            result = this.executeRequest(invocation, methodInvocation);
        }
        catch (Throwable ex) {
            RemoteAccessException rae = this.convertHttpInvokerAccessException(ex);
            throw rae != null ? rae : ex;
        }
        try {
            return this.recreateRemoteInvocationResult(result);
        }
        catch (Throwable ex) {
            if (result.hasInvocationTargetException()) {
                throw ex;
            }
            throw new RemoteInvocationFailureException("Invocation of method [" + methodInvocation.getMethod() + "] failed in HTTP invoker remote service at [" + this.getServiceUrl() + "]", ex);
        }
    }

    protected RemoteInvocationResult executeRequest(RemoteInvocation invocation, MethodInvocation originalInvocation) throws Exception {
        return this.executeRequest(invocation);
    }

    protected RemoteInvocationResult executeRequest(RemoteInvocation invocation) throws Exception {
        return this.getHttpInvokerRequestExecutor().executeRequest(this, invocation);
    }

    @Nullable
    protected RemoteAccessException convertHttpInvokerAccessException(Throwable ex) {
        if (ex instanceof ConnectException) {
            return new RemoteConnectFailureException("Could not connect to HTTP invoker remote service at [" + this.getServiceUrl() + "]", ex);
        }
        if (ex instanceof ClassNotFoundException || ex instanceof NoClassDefFoundError || ex instanceof InvalidClassException) {
            return new RemoteAccessException("Could not deserialize result from HTTP invoker remote service [" + this.getServiceUrl() + "]", ex);
        }
        if (ex instanceof Exception) {
            return new RemoteAccessException("Could not access HTTP invoker remote service at [" + this.getServiceUrl() + "]", ex);
        }
        return null;
    }
}

