/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.accept;

import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import keycloakjar.org.springframework.core.io.Resource;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.MediaTypeFactory;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.StringUtils;
import keycloakjar.org.springframework.web.accept.AbstractMappingContentNegotiationStrategy;
import keycloakjar.org.springframework.web.context.request.NativeWebRequest;
import keycloakjar.org.springframework.web.util.UriUtils;
import keycloakjar.org.springframework.web.util.UrlPathHelper;

public class PathExtensionContentNegotiationStrategy
extends AbstractMappingContentNegotiationStrategy {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();

    public PathExtensionContentNegotiationStrategy() {
        this(null);
    }

    public PathExtensionContentNegotiationStrategy(@Nullable Map<String, MediaType> mediaTypes) {
        super(mediaTypes);
        this.setUseRegisteredExtensionsOnly(false);
        this.setIgnoreUnknownExtensions(true);
        this.urlPathHelper.setUrlDecode(false);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    @Deprecated
    public void setUseJaf(boolean useJaf) {
        this.setUseRegisteredExtensionsOnly(!useJaf);
    }

    @Override
    @Nullable
    protected String getMediaTypeKey(NativeWebRequest webRequest) {
        HttpServletRequest request = webRequest.getNativeRequest(HttpServletRequest.class);
        if (request == null) {
            return null;
        }
        String path = this.urlPathHelper.getLookupPathForRequest(request);
        String extension = UriUtils.extractFileExtension(path);
        return StringUtils.hasText(extension) ? extension.toLowerCase(Locale.ENGLISH) : null;
    }

    @Nullable
    public MediaType getMediaTypeForResource(Resource resource) {
        Assert.notNull((Object)resource, "Resource must not be null");
        MediaType mediaType = null;
        String filename = resource.getFilename();
        String extension = StringUtils.getFilenameExtension(filename);
        if (extension != null) {
            mediaType = this.lookupMediaType(extension);
        }
        if (mediaType == null) {
            mediaType = MediaTypeFactory.getMediaType(filename).orElse(null);
        }
        return mediaType;
    }
}

