/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.bind;

import javax.servlet.ServletRequest;
import keycloakjar.org.springframework.beans.MutablePropertyValues;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.validation.BindException;
import keycloakjar.org.springframework.web.bind.ServletRequestBindingException;
import keycloakjar.org.springframework.web.bind.ServletRequestParameterPropertyValues;
import keycloakjar.org.springframework.web.bind.WebDataBinder;
import keycloakjar.org.springframework.web.multipart.MultipartRequest;
import keycloakjar.org.springframework.web.util.WebUtils;

public class ServletRequestDataBinder
extends WebDataBinder {
    public ServletRequestDataBinder(@Nullable Object target) {
        super(target);
    }

    public ServletRequestDataBinder(@Nullable Object target, String objectName) {
        super(target, objectName);
    }

    public void bind(ServletRequest request) {
        ServletRequestParameterPropertyValues mpvs = new ServletRequestParameterPropertyValues(request);
        MultipartRequest multipartRequest = WebUtils.getNativeRequest(request, MultipartRequest.class);
        if (multipartRequest != null) {
            this.bindMultipart(multipartRequest.getMultiFileMap(), mpvs);
        }
        this.addBindValues(mpvs, request);
        this.doBind(mpvs);
    }

    protected void addBindValues(MutablePropertyValues mpvs, ServletRequest request) {
    }

    public void closeNoCatch() throws ServletRequestBindingException {
        if (this.getBindingResult().hasErrors()) {
            throw new ServletRequestBindingException("Errors binding onto object '" + this.getBindingResult().getObjectName() + "'", (Throwable)new BindException(this.getBindingResult()));
        }
    }
}

