/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.context.support;

import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import keycloakjar.org.springframework.context.ConfigurableApplicationContext;
import keycloakjar.org.springframework.context.support.LiveBeansView;
import keycloakjar.org.springframework.util.Assert;

public class ServletContextLiveBeansView
extends LiveBeansView {
    private final ServletContext servletContext;

    public ServletContextLiveBeansView(ServletContext servletContext) {
        Assert.notNull((Object)servletContext, "ServletContext must not be null");
        this.servletContext = servletContext;
    }

    protected Set<ConfigurableApplicationContext> findApplicationContexts() {
        LinkedHashSet<ConfigurableApplicationContext> contexts = new LinkedHashSet<ConfigurableApplicationContext>();
        Enumeration attrNames = this.servletContext.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            Object attrValue = this.servletContext.getAttribute(attrName);
            if (!(attrValue instanceof ConfigurableApplicationContext)) continue;
            contexts.add((ConfigurableApplicationContext)attrValue);
        }
        return contexts;
    }
}

