/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.cors;

import javax.servlet.http.HttpServletRequest;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.ObjectUtils;
import keycloakjar.org.springframework.web.util.UriComponents;
import keycloakjar.org.springframework.web.util.UriComponentsBuilder;

public abstract class CorsUtils {
    public static boolean isCorsRequest(HttpServletRequest request) {
        String origin = request.getHeader("Origin");
        if (origin == null) {
            return false;
        }
        UriComponents originUrl = UriComponentsBuilder.fromOriginHeader(origin).build();
        String scheme = request.getScheme();
        String host = request.getServerName();
        int port = request.getServerPort();
        return !ObjectUtils.nullSafeEquals(scheme, originUrl.getScheme()) || !ObjectUtils.nullSafeEquals(host, originUrl.getHost()) || CorsUtils.getPort(scheme, port) != CorsUtils.getPort(originUrl.getScheme(), originUrl.getPort());
    }

    private static int getPort(@Nullable String scheme, int port) {
        if (port == -1) {
            if ("http".equals(scheme) || "ws".equals(scheme)) {
                port = 80;
            } else if ("https".equals(scheme) || "wss".equals(scheme)) {
                port = 443;
            }
        }
        return port;
    }

    public static boolean isPreFlightRequest(HttpServletRequest request) {
        return HttpMethod.OPTIONS.matches(request.getMethod()) && request.getHeader("Access-Control-Request-Method") != null;
    }
}

