/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.method.annotation;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import keycloakjar.org.springframework.core.MethodParameter;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.LinkedMultiValueMap;
import keycloakjar.org.springframework.util.MultiValueMap;
import keycloakjar.org.springframework.util.StringUtils;
import keycloakjar.org.springframework.web.bind.annotation.RequestParam;
import keycloakjar.org.springframework.web.bind.support.WebDataBinderFactory;
import keycloakjar.org.springframework.web.context.request.NativeWebRequest;
import keycloakjar.org.springframework.web.method.support.HandlerMethodArgumentResolver;
import keycloakjar.org.springframework.web.method.support.ModelAndViewContainer;
import keycloakjar.org.springframework.web.multipart.MultipartFile;
import keycloakjar.org.springframework.web.multipart.MultipartRequest;
import keycloakjar.org.springframework.web.multipart.support.MultipartResolutionDelegate;

public class RequestParamMapMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        RequestParam requestParam = parameter.getParameterAnnotation(RequestParam.class);
        return requestParam != null && Map.class.isAssignableFrom(parameter.getParameterType()) && !StringUtils.hasText(requestParam.name());
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        ResolvableType resolvableType = ResolvableType.forMethodParameter(parameter);
        if (MultiValueMap.class.isAssignableFrom(parameter.getParameterType())) {
            Class<?> valueType = resolvableType.as(MultiValueMap.class).getGeneric(1).resolve();
            if (valueType == MultipartFile.class) {
                MultipartRequest multipartRequest = MultipartResolutionDelegate.resolveMultipartRequest(webRequest);
                return multipartRequest != null ? multipartRequest.getMultiFileMap() : new LinkedMultiValueMap(0);
            }
            if (valueType == Part.class) {
                HttpServletRequest servletRequest = webRequest.getNativeRequest(HttpServletRequest.class);
                if (servletRequest != null && MultipartResolutionDelegate.isMultipartRequest(servletRequest)) {
                    Collection parts = servletRequest.getParts();
                    LinkedMultiValueMap<String, Part> result = new LinkedMultiValueMap<String, Part>(parts.size());
                    for (Part part : parts) {
                        result.add(part.getName(), part);
                    }
                    return result;
                }
                return new LinkedMultiValueMap(0);
            }
            Map<String, String[]> parameterMap = webRequest.getParameterMap();
            LinkedMultiValueMap result = new LinkedMultiValueMap(parameterMap.size());
            parameterMap.forEach((key, values) -> {
                for (String value : values) {
                    result.add(key, value);
                }
            });
            return result;
        }
        Class<?> valueType = resolvableType.asMap().getGeneric(1).resolve();
        if (valueType == MultipartFile.class) {
            MultipartRequest multipartRequest = MultipartResolutionDelegate.resolveMultipartRequest(webRequest);
            return multipartRequest != null ? multipartRequest.getFileMap() : new LinkedHashMap(0);
        }
        if (valueType == Part.class) {
            HttpServletRequest servletRequest = webRequest.getNativeRequest(HttpServletRequest.class);
            if (servletRequest != null && MultipartResolutionDelegate.isMultipartRequest(servletRequest)) {
                Collection parts = servletRequest.getParts();
                LinkedHashMap<String, Part> result = new LinkedHashMap<String, Part>(parts.size());
                for (Part part : parts) {
                    if (result.containsKey(part.getName())) continue;
                    result.put(part.getName(), part);
                }
                return result;
            }
            return new LinkedHashMap(0);
        }
        Map<String, String[]> parameterMap = webRequest.getParameterMap();
        LinkedHashMap result = new LinkedHashMap(parameterMap.size());
        parameterMap.forEach((key, values) -> {
            if (((String[])values).length > 0) {
                result.put(key, values[0]);
            }
        });
        return result;
    }
}

