/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.client.reactive;

import java.net.URI;
import java.util.function.Consumer;
import java.util.function.Function;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferFactory;
import keycloakjar.org.springframework.core.io.buffer.DefaultDataBufferFactory;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.http.client.reactive.ClientHttpConnector;
import keycloakjar.org.springframework.http.client.reactive.ClientHttpRequest;
import keycloakjar.org.springframework.http.client.reactive.ClientHttpResponse;
import keycloakjar.org.springframework.http.client.reactive.JettyClientHttpRequest;
import keycloakjar.org.springframework.http.client.reactive.JettyClientHttpResponse;
import keycloakjar.org.springframework.http.client.reactive.JettyResourceFactory;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.reactive.client.ContentChunk;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JettyClientHttpConnector
implements ClientHttpConnector {
    private final HttpClient httpClient;
    private DataBufferFactory bufferFactory = new DefaultDataBufferFactory();

    public JettyClientHttpConnector() {
        this(new HttpClient());
    }

    public JettyClientHttpConnector(HttpClient httpClient) {
        this(httpClient, null);
    }

    public JettyClientHttpConnector(HttpClient httpClient, @Nullable JettyResourceFactory resourceFactory) {
        Assert.notNull((Object)httpClient, "HttpClient is required");
        if (resourceFactory != null) {
            httpClient.setExecutor(resourceFactory.getExecutor());
            httpClient.setByteBufferPool(resourceFactory.getByteBufferPool());
            httpClient.setScheduler(resourceFactory.getScheduler());
        }
        this.httpClient = httpClient;
    }

    @Deprecated
    public JettyClientHttpConnector(JettyResourceFactory resourceFactory, @Nullable Consumer<HttpClient> customizer) {
        this(new HttpClient(), resourceFactory);
        if (customizer != null) {
            customizer.accept(this.httpClient);
        }
    }

    public void setBufferFactory(DataBufferFactory bufferFactory) {
        this.bufferFactory = bufferFactory;
    }

    @Override
    public Mono<ClientHttpResponse> connect(HttpMethod method, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        if (!uri.isAbsolute()) {
            return Mono.error((Throwable)new IllegalArgumentException("URI is not absolute: " + uri));
        }
        if (!this.httpClient.isStarted()) {
            try {
                this.httpClient.start();
            }
            catch (Exception ex) {
                return Mono.error((Throwable)ex);
            }
        }
        JettyClientHttpRequest clientHttpRequest = new JettyClientHttpRequest(this.httpClient.newRequest(uri).method(method.toString()), this.bufferFactory);
        return requestCallback.apply(clientHttpRequest).then(Mono.from((Publisher)clientHttpRequest.getReactiveRequest().response((response, chunks) -> {
            Flux content = Flux.from((Publisher)chunks).map(this::toDataBuffer);
            return Mono.just((Object)new JettyClientHttpResponse((ReactiveResponse)response, (Publisher<DataBuffer>)content));
        })));
    }

    private DataBuffer toDataBuffer(ContentChunk chunk) {
        DataBuffer buffer = this.bufferFactory.allocateBuffer(chunk.buffer.capacity());
        buffer.write(chunk.buffer);
        chunk.callback.succeeded();
        return buffer;
    }
}

