/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.client.reactive;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import keycloakjar.org.apache.commons.logging.Log;
import keycloakjar.org.apache.commons.logging.LogFactory;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.NettyDataBufferFactory;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.http.ResponseCookie;
import keycloakjar.org.springframework.http.client.reactive.ClientHttpResponse;
import keycloakjar.org.springframework.util.CollectionUtils;
import keycloakjar.org.springframework.util.LinkedMultiValueMap;
import keycloakjar.org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.netty.Connection;
import reactor.netty.NettyInbound;
import reactor.netty.http.client.HttpClientResponse;

class ReactorClientHttpResponse
implements ClientHttpResponse {
    private static final Log logger = LogFactory.getLog(ReactorClientHttpResponse.class);
    private final HttpClientResponse response;
    private final NettyInbound inbound;
    private final NettyDataBufferFactory bufferFactory;
    private final AtomicInteger state = new AtomicInteger(0);
    private final String logPrefix;

    public ReactorClientHttpResponse(HttpClientResponse response, Connection connection) {
        this.response = response;
        this.inbound = connection.inbound();
        this.bufferFactory = new NettyDataBufferFactory(connection.outbound().alloc());
        this.logPrefix = logger.isDebugEnabled() ? "[" + connection.channel().id().asShortText() + "] " : "";
    }

    @Deprecated
    public ReactorClientHttpResponse(HttpClientResponse response, NettyInbound inbound, ByteBufAllocator alloc) {
        this.response = response;
        this.inbound = inbound;
        this.bufferFactory = new NettyDataBufferFactory(alloc);
        this.logPrefix = "";
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.inbound.receive().doOnSubscribe(s -> {
            if (this.state.compareAndSet(0, 1)) {
                return;
            }
            if (this.state.get() == 2) {
                throw new IllegalStateException("The client response body has been released already due to cancellation.");
            }
        }).map(byteBuf -> {
            byteBuf.retain();
            return this.bufferFactory.wrap((ByteBuf)byteBuf);
        });
    }

    @Override
    public HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        this.response.responseHeaders().entries().forEach(e -> headers.add((String)e.getKey(), (String)e.getValue()));
        return headers;
    }

    @Override
    public HttpStatus getStatusCode() {
        return HttpStatus.valueOf(this.getRawStatusCode());
    }

    @Override
    public int getRawStatusCode() {
        return this.response.status().code();
    }

    @Override
    public MultiValueMap<String, ResponseCookie> getCookies() {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        this.response.cookies().values().stream().flatMap(Collection::stream).forEach(c -> result.add(c.name(), ResponseCookie.fromClientResponse(c.name(), c.value()).domain(c.domain()).path(c.path()).maxAge(c.maxAge()).secure(c.isSecure()).httpOnly(c.isHttpOnly()).build()));
        return CollectionUtils.unmodifiableMultiValueMap(result);
    }

    void releaseAfterCancel(HttpMethod method) {
        if (this.mayHaveBody(method) && this.state.compareAndSet(0, 2)) {
            if (logger.isDebugEnabled()) {
                logger.debug(this.logPrefix + "Releasing body, not yet subscribed.");
            }
            this.inbound.receive().doOnNext(byteBuf -> {}).subscribe(byteBuf -> {}, ex -> {});
        }
    }

    private boolean mayHaveBody(HttpMethod method) {
        int code = this.getRawStatusCode();
        return (code < 100 || code >= 200) && code != 204 && code != 205 && !method.equals((Object)HttpMethod.HEAD) && this.getHeaders().getContentLength() != 0L;
    }

    public String toString() {
        return "ReactorClientHttpResponse{request=[" + this.response.method().name() + " " + this.response.uri() + "],status=" + this.getRawStatusCode() + '}';
    }
}

