/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.codec.support;

import com.google.protobuf.Message;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import keycloakjar.org.springframework.core.codec.AbstractDataBufferDecoder;
import keycloakjar.org.springframework.core.codec.ByteArrayDecoder;
import keycloakjar.org.springframework.core.codec.ByteArrayEncoder;
import keycloakjar.org.springframework.core.codec.ByteBufferDecoder;
import keycloakjar.org.springframework.core.codec.ByteBufferEncoder;
import keycloakjar.org.springframework.core.codec.CharSequenceEncoder;
import keycloakjar.org.springframework.core.codec.DataBufferDecoder;
import keycloakjar.org.springframework.core.codec.DataBufferEncoder;
import keycloakjar.org.springframework.core.codec.Decoder;
import keycloakjar.org.springframework.core.codec.Encoder;
import keycloakjar.org.springframework.core.codec.ResourceDecoder;
import keycloakjar.org.springframework.core.codec.StringDecoder;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.http.codec.CodecConfigurer;
import keycloakjar.org.springframework.http.codec.DecoderHttpMessageReader;
import keycloakjar.org.springframework.http.codec.EncoderHttpMessageWriter;
import keycloakjar.org.springframework.http.codec.FormHttpMessageReader;
import keycloakjar.org.springframework.http.codec.FormHttpMessageWriter;
import keycloakjar.org.springframework.http.codec.HttpMessageReader;
import keycloakjar.org.springframework.http.codec.HttpMessageWriter;
import keycloakjar.org.springframework.http.codec.ResourceHttpMessageReader;
import keycloakjar.org.springframework.http.codec.ResourceHttpMessageWriter;
import keycloakjar.org.springframework.http.codec.ServerSentEventHttpMessageReader;
import keycloakjar.org.springframework.http.codec.json.AbstractJackson2Decoder;
import keycloakjar.org.springframework.http.codec.json.Jackson2JsonDecoder;
import keycloakjar.org.springframework.http.codec.json.Jackson2JsonEncoder;
import keycloakjar.org.springframework.http.codec.json.Jackson2SmileDecoder;
import keycloakjar.org.springframework.http.codec.json.Jackson2SmileEncoder;
import keycloakjar.org.springframework.http.codec.multipart.MultipartHttpMessageReader;
import keycloakjar.org.springframework.http.codec.multipart.MultipartHttpMessageWriter;
import keycloakjar.org.springframework.http.codec.multipart.SynchronossPartHttpMessageReader;
import keycloakjar.org.springframework.http.codec.protobuf.ProtobufDecoder;
import keycloakjar.org.springframework.http.codec.protobuf.ProtobufEncoder;
import keycloakjar.org.springframework.http.codec.protobuf.ProtobufHttpMessageWriter;
import keycloakjar.org.springframework.http.codec.support.BaseCodecConfigurer;
import keycloakjar.org.springframework.http.codec.xml.Jaxb2XmlDecoder;
import keycloakjar.org.springframework.http.codec.xml.Jaxb2XmlEncoder;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.ClassUtils;

class BaseDefaultCodecs
implements CodecConfigurer.DefaultCodecs,
CodecConfigurer.DefaultCodecConfig {
    static final boolean jackson2Present;
    private static final boolean jackson2SmilePresent;
    private static final boolean jaxb2Present;
    private static final boolean protobufPresent;
    static final boolean synchronossMultipartPresent;
    @Nullable
    private Decoder<?> jackson2JsonDecoder;
    @Nullable
    private Encoder<?> jackson2JsonEncoder;
    @Nullable
    private Encoder<?> jackson2SmileEncoder;
    @Nullable
    private Decoder<?> jackson2SmileDecoder;
    @Nullable
    private Decoder<?> protobufDecoder;
    @Nullable
    private Encoder<?> protobufEncoder;
    @Nullable
    private Decoder<?> jaxb2Decoder;
    @Nullable
    private Encoder<?> jaxb2Encoder;
    @Nullable
    private Integer maxInMemorySize;
    @Nullable
    private Boolean enableLoggingRequestDetails;
    private boolean registerDefaults = true;

    BaseDefaultCodecs() {
    }

    protected BaseDefaultCodecs(BaseDefaultCodecs other) {
        this.jackson2JsonDecoder = other.jackson2JsonDecoder;
        this.jackson2JsonEncoder = other.jackson2JsonEncoder;
        this.jackson2SmileDecoder = other.jackson2SmileDecoder;
        this.jackson2SmileEncoder = other.jackson2SmileEncoder;
        this.protobufDecoder = other.protobufDecoder;
        this.protobufEncoder = other.protobufEncoder;
        this.jaxb2Decoder = other.jaxb2Decoder;
        this.jaxb2Encoder = other.jaxb2Encoder;
        this.maxInMemorySize = other.maxInMemorySize;
        this.enableLoggingRequestDetails = other.enableLoggingRequestDetails;
        this.registerDefaults = other.registerDefaults;
    }

    @Override
    public void jackson2JsonDecoder(Decoder<?> decoder) {
        this.jackson2JsonDecoder = decoder;
    }

    @Override
    public void jackson2JsonEncoder(Encoder<?> encoder) {
        this.jackson2JsonEncoder = encoder;
    }

    @Override
    public void protobufDecoder(Decoder<?> decoder) {
        this.protobufDecoder = decoder;
    }

    @Override
    public void jackson2SmileDecoder(Decoder<?> decoder) {
        this.jackson2SmileDecoder = decoder;
    }

    @Override
    public void jackson2SmileEncoder(Encoder<?> encoder) {
        this.jackson2SmileEncoder = encoder;
    }

    @Override
    public void protobufEncoder(Encoder<?> encoder) {
        this.protobufEncoder = encoder;
    }

    @Override
    public void jaxb2Decoder(Decoder<?> decoder) {
        this.jaxb2Decoder = decoder;
    }

    @Override
    public void jaxb2Encoder(Encoder<?> encoder) {
        this.jaxb2Encoder = encoder;
    }

    @Override
    public void maxInMemorySize(int byteCount) {
        this.maxInMemorySize = byteCount;
    }

    @Override
    @Nullable
    public Integer maxInMemorySize() {
        return this.maxInMemorySize;
    }

    @Override
    public void enableLoggingRequestDetails(boolean enable) {
        this.enableLoggingRequestDetails = enable;
    }

    @Override
    @Nullable
    public Boolean isEnableLoggingRequestDetails() {
        return this.enableLoggingRequestDetails;
    }

    void registerDefaults(boolean registerDefaults) {
        this.registerDefaults = registerDefaults;
    }

    final List<HttpMessageReader<?>> getTypedReaders() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList readers = new ArrayList();
        this.addCodec(readers, new DecoderHttpMessageReader<byte[]>(new ByteArrayDecoder()));
        this.addCodec(readers, new DecoderHttpMessageReader<ByteBuffer>(new ByteBufferDecoder()));
        this.addCodec(readers, new DecoderHttpMessageReader<DataBuffer>(new DataBufferDecoder()));
        this.addCodec(readers, new ResourceHttpMessageReader(new ResourceDecoder()));
        this.addCodec(readers, new DecoderHttpMessageReader<String>(StringDecoder.textPlainOnly()));
        if (protobufPresent) {
            this.addCodec(readers, new DecoderHttpMessageReader<Message>(this.protobufDecoder != null ? (ProtobufDecoder)this.protobufDecoder : new ProtobufDecoder()));
        }
        this.addCodec(readers, new FormHttpMessageReader());
        this.extendTypedReaders(readers);
        return readers;
    }

    protected <T> void addCodec(List<T> codecs, T codec) {
        this.initCodec(codec);
        codecs.add(codec);
    }

    private void initCodec(@Nullable Object codec) {
        Boolean enable;
        if (codec instanceof DecoderHttpMessageReader) {
            codec = ((DecoderHttpMessageReader)((Object)codec)).getDecoder();
        }
        if (codec == null) {
            return;
        }
        Integer size = this.maxInMemorySize;
        if (size != null) {
            if (codec instanceof AbstractDataBufferDecoder) {
                ((AbstractDataBufferDecoder)codec).setMaxInMemorySize(size);
            }
            if (protobufPresent && codec instanceof ProtobufDecoder) {
                ((ProtobufDecoder)codec).setMaxMessageSize(size);
            }
            if (jackson2Present && codec instanceof AbstractJackson2Decoder) {
                ((AbstractJackson2Decoder)codec).setMaxInMemorySize(size);
            }
            if (jaxb2Present && codec instanceof Jaxb2XmlDecoder) {
                ((Jaxb2XmlDecoder)codec).setMaxInMemorySize(size);
            }
            if (codec instanceof FormHttpMessageReader) {
                ((FormHttpMessageReader)((Object)codec)).setMaxInMemorySize(size);
            }
            if (codec instanceof ServerSentEventHttpMessageReader) {
                ((ServerSentEventHttpMessageReader)((Object)codec)).setMaxInMemorySize(size);
                this.initCodec(((ServerSentEventHttpMessageReader)((Object)codec)).getDecoder());
            }
            if (synchronossMultipartPresent && codec instanceof SynchronossPartHttpMessageReader) {
                ((SynchronossPartHttpMessageReader)((Object)codec)).setMaxInMemorySize(size);
            }
        }
        if ((enable = this.enableLoggingRequestDetails) != null) {
            if (codec instanceof FormHttpMessageReader) {
                ((FormHttpMessageReader)((Object)codec)).setEnableLoggingRequestDetails(enable);
            }
            if (codec instanceof MultipartHttpMessageReader) {
                ((MultipartHttpMessageReader)((Object)codec)).setEnableLoggingRequestDetails(enable);
            }
            if (synchronossMultipartPresent && codec instanceof SynchronossPartHttpMessageReader) {
                ((SynchronossPartHttpMessageReader)((Object)codec)).setEnableLoggingRequestDetails(enable);
            }
            if (codec instanceof FormHttpMessageWriter) {
                ((FormHttpMessageWriter)((Object)codec)).setEnableLoggingRequestDetails(enable);
            }
            if (codec instanceof MultipartHttpMessageWriter) {
                ((MultipartHttpMessageWriter)((Object)codec)).setEnableLoggingRequestDetails(enable);
            }
        }
        if (codec instanceof MultipartHttpMessageReader) {
            this.initCodec(((MultipartHttpMessageReader)((Object)codec)).getPartReader());
        } else if (codec instanceof MultipartHttpMessageWriter) {
            this.initCodec(((MultipartHttpMessageWriter)((Object)codec)).getFormWriter());
        }
    }

    protected void extendTypedReaders(List<HttpMessageReader<?>> typedReaders) {
    }

    final List<HttpMessageReader<?>> getObjectReaders() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList readers = new ArrayList();
        if (jackson2Present) {
            this.addCodec(readers, new DecoderHttpMessageReader(this.getJackson2JsonDecoder()));
        }
        if (jackson2SmilePresent) {
            this.addCodec(readers, new DecoderHttpMessageReader<Object>(this.jackson2SmileDecoder != null ? (Jackson2SmileDecoder)this.jackson2SmileDecoder : new Jackson2SmileDecoder()));
        }
        if (jaxb2Present) {
            this.addCodec(readers, new DecoderHttpMessageReader<Object>(this.jaxb2Decoder != null ? (Jaxb2XmlDecoder)this.jaxb2Decoder : new Jaxb2XmlDecoder()));
        }
        this.extendObjectReaders(readers);
        return readers;
    }

    protected void extendObjectReaders(List<HttpMessageReader<?>> objectReaders) {
    }

    final List<HttpMessageReader<?>> getCatchAllReaders() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList readers = new ArrayList();
        this.addCodec(readers, new DecoderHttpMessageReader<String>(StringDecoder.allMimeTypes()));
        return readers;
    }

    final List<HttpMessageWriter<?>> getTypedWriters() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        List<HttpMessageWriter<?>> writers = this.getBaseTypedWriters();
        this.extendTypedWriters(writers);
        return writers;
    }

    final List<HttpMessageWriter<?>> getBaseTypedWriters() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList writers = new ArrayList();
        writers.add(new EncoderHttpMessageWriter<byte[]>(new ByteArrayEncoder()));
        writers.add(new EncoderHttpMessageWriter<ByteBuffer>(new ByteBufferEncoder()));
        writers.add(new EncoderHttpMessageWriter<DataBuffer>(new DataBufferEncoder()));
        writers.add(new ResourceHttpMessageWriter());
        writers.add(new EncoderHttpMessageWriter<CharSequence>(CharSequenceEncoder.textPlainOnly()));
        if (protobufPresent) {
            writers.add(new ProtobufHttpMessageWriter(this.protobufEncoder != null ? (ProtobufEncoder)this.protobufEncoder : new ProtobufEncoder()));
        }
        return writers;
    }

    protected void extendTypedWriters(List<HttpMessageWriter<?>> typedWriters) {
    }

    final List<HttpMessageWriter<?>> getObjectWriters() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        List<HttpMessageWriter<?>> writers = this.getBaseObjectWriters();
        this.extendObjectWriters(writers);
        return writers;
    }

    final List<HttpMessageWriter<?>> getBaseObjectWriters() {
        ArrayList writers = new ArrayList();
        if (jackson2Present) {
            writers.add(new EncoderHttpMessageWriter(this.getJackson2JsonEncoder()));
        }
        if (jackson2SmilePresent) {
            writers.add(new EncoderHttpMessageWriter<Object>(this.jackson2SmileEncoder != null ? (Jackson2SmileEncoder)this.jackson2SmileEncoder : new Jackson2SmileEncoder()));
        }
        if (jaxb2Present) {
            writers.add(new EncoderHttpMessageWriter<Object>(this.jaxb2Encoder != null ? (Jaxb2XmlEncoder)this.jaxb2Encoder : new Jaxb2XmlEncoder()));
        }
        return writers;
    }

    protected void extendObjectWriters(List<HttpMessageWriter<?>> objectWriters) {
    }

    List<HttpMessageWriter<?>> getCatchAllWriters() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        result.add(new EncoderHttpMessageWriter<CharSequence>(CharSequenceEncoder.allMimeTypes()));
        return result;
    }

    void applyDefaultConfig(BaseCodecConfigurer.DefaultCustomCodecs customCodecs) {
        this.applyDefaultConfig(customCodecs.getTypedReaders());
        this.applyDefaultConfig(customCodecs.getObjectReaders());
        this.applyDefaultConfig(customCodecs.getTypedWriters());
        this.applyDefaultConfig(customCodecs.getObjectWriters());
        customCodecs.getDefaultConfigConsumers().forEach(consumer -> consumer.accept(this));
    }

    private void applyDefaultConfig(Map<?, Boolean> readers) {
        readers.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).forEach(this::initCodec);
    }

    protected Decoder<?> getJackson2JsonDecoder() {
        if (this.jackson2JsonDecoder == null) {
            this.jackson2JsonDecoder = new Jackson2JsonDecoder();
        }
        return this.jackson2JsonDecoder;
    }

    protected Encoder<?> getJackson2JsonEncoder() {
        if (this.jackson2JsonEncoder == null) {
            this.jackson2JsonEncoder = new Jackson2JsonEncoder();
        }
        return this.jackson2JsonEncoder;
    }

    static {
        ClassLoader classLoader = BaseCodecConfigurer.class.getClassLoader();
        jackson2Present = ClassUtils.isPresent("com.fasterxml.jackson.databind.ObjectMapper", classLoader) && ClassUtils.isPresent("com.fasterxml.jackson.core.JsonGenerator", classLoader);
        jackson2SmilePresent = ClassUtils.isPresent("com.fasterxml.jackson.dataformat.smile.SmileFactory", classLoader);
        jaxb2Present = ClassUtils.isPresent("javax.xml.bind.Binder", classLoader);
        protobufPresent = ClassUtils.isPresent("com.google.protobuf.Message", classLoader);
        synchronossMultipartPresent = ClassUtils.isPresent("org.synchronoss.cloud.nio.multipart.NioMultipartParser", classLoader);
    }
}

