/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.util.concurrent;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.concurrent.FailureCallback;
import keycloakjar.org.springframework.util.concurrent.ListenableFuture;
import keycloakjar.org.springframework.util.concurrent.ListenableFutureCallback;
import keycloakjar.org.springframework.util.concurrent.ListenableFutureCallbackRegistry;
import keycloakjar.org.springframework.util.concurrent.SuccessCallback;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public class MonoToListenableFutureAdapter<T>
implements ListenableFuture<T> {
    private final MonoProcessor<T> processor;
    private final ListenableFutureCallbackRegistry<T> registry = new ListenableFutureCallbackRegistry();

    public MonoToListenableFutureAdapter(Mono<T> mono2) {
        Assert.notNull(mono2, "Mono must not be null");
        this.processor = mono2.doOnSuccess(this.registry::success).doOnError(this.registry::failure).toProcessor();
    }

    @Override
    @Nullable
    public T get() {
        return (T)this.processor.block();
    }

    @Override
    @Nullable
    public T get(long timeout, TimeUnit unit) {
        Assert.notNull((Object)unit, "TimeUnit must not be null");
        Duration duration = Duration.ofMillis(TimeUnit.MILLISECONDS.convert(timeout, unit));
        return (T)this.processor.block(duration);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isCancelled()) {
            return false;
        }
        this.processor.cancel();
        return this.processor.isCancelled();
    }

    @Override
    public boolean isCancelled() {
        return this.processor.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.processor.isTerminated();
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.registry.addCallback(callback);
    }

    @Override
    public void addCallback(SuccessCallback<? super T> success, FailureCallback failure) {
        this.registry.addSuccessCallback(success);
        this.registry.addFailureCallback(failure);
    }
}

