/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.bind.support;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import keycloakjar.org.springframework.beans.MutablePropertyValues;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.LinkedMultiValueMap;
import keycloakjar.org.springframework.util.StringUtils;
import keycloakjar.org.springframework.validation.BindException;
import keycloakjar.org.springframework.web.bind.WebDataBinder;
import keycloakjar.org.springframework.web.context.request.NativeWebRequest;
import keycloakjar.org.springframework.web.context.request.WebRequest;
import keycloakjar.org.springframework.web.multipart.MultipartException;
import keycloakjar.org.springframework.web.multipart.MultipartRequest;

public class WebRequestDataBinder
extends WebDataBinder {
    public WebRequestDataBinder(@Nullable Object target) {
        super(target);
    }

    public WebRequestDataBinder(@Nullable Object target, String objectName) {
        super(target, objectName);
    }

    public void bind(WebRequest request) {
        MutablePropertyValues mpvs = new MutablePropertyValues(request.getParameterMap());
        if (request instanceof NativeWebRequest) {
            HttpServletRequest servletRequest;
            MultipartRequest multipartRequest = ((NativeWebRequest)request).getNativeRequest(MultipartRequest.class);
            if (multipartRequest != null) {
                this.bindMultipart(multipartRequest.getMultiFileMap(), mpvs);
            } else if (this.isMultipartRequest(request) && (servletRequest = ((NativeWebRequest)request).getNativeRequest(HttpServletRequest.class)) != null) {
                this.bindParts(servletRequest, mpvs);
            }
        }
        this.doBind(mpvs);
    }

    private boolean isMultipartRequest(WebRequest request) {
        String contentType = request.getHeader("Content-Type");
        return StringUtils.startsWithIgnoreCase(contentType, "multipart/");
    }

    private void bindParts(HttpServletRequest request, MutablePropertyValues mpvs) {
        try {
            LinkedMultiValueMap<String, Object> map = new LinkedMultiValueMap<String, Object>();
            for (Part part : request.getParts()) {
                map.add(part.getName(), part);
            }
            map.forEach((key, values) -> {
                if (values.size() == 1) {
                    Part part = (Part)values.get(0);
                    if (this.isBindEmptyMultipartFiles() || part.getSize() > 0L) {
                        mpvs.add((String)key, part);
                    }
                } else {
                    mpvs.add((String)key, values);
                }
            });
        }
        catch (Exception ex) {
            throw new MultipartException("Failed to get request parts", ex);
        }
    }

    public void closeNoCatch() throws BindException {
        if (this.getBindingResult().hasErrors()) {
            throw new BindException(this.getBindingResult());
        }
    }
}

