/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak;

import keycloakjar.com.google.gson.JsonObject;
import keycloakjar.org.springframework.http.HttpEntity;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.http.ResponseEntity;
import keycloakjar.org.springframework.web.client.RestClientException;
import keycloakjar.org.springframework.web.client.RestTemplate;
import org.camunda.bpm.engine.impl.identity.IdentityProviderException;
import org.camunda.bpm.extension.keycloak.KeycloakConfiguration;
import org.camunda.bpm.extension.keycloak.KeycloakContext;
import org.camunda.bpm.extension.keycloak.json.JsonException;
import org.camunda.bpm.extension.keycloak.json.JsonUtil;
import org.camunda.bpm.extension.keycloak.util.KeycloakPluginLogger;

public class KeycloakContextProvider {
    private static final KeycloakPluginLogger LOG = KeycloakPluginLogger.INSTANCE;
    protected KeycloakConfiguration keycloakConfiguration;
    protected RestTemplate restTemplate;
    protected KeycloakContext context;

    public KeycloakContextProvider(KeycloakConfiguration keycloakConfiguration, RestTemplate restTemplate) {
        this.keycloakConfiguration = keycloakConfiguration;
        this.restTemplate = restTemplate;
    }

    private KeycloakContext openAuthorizationContext() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/x-www-form-urlencoded;charset=" + this.keycloakConfiguration.getCharset());
        HttpEntity<String> request = new HttpEntity<String>("client_id=" + this.keycloakConfiguration.getClientId() + "&client_secret=" + this.keycloakConfiguration.getClientSecret() + "&grant_type=client_credentials", headers);
        try {
            ResponseEntity<String> response = this.restTemplate.postForEntity(this.keycloakConfiguration.getKeycloakIssuerUrl() + "/protocol/openid-connect/token", request, String.class, new Object[0]);
            if (!response.getStatusCode().equals((Object)HttpStatus.OK)) {
                throw new IdentityProviderException("Could not connect to " + this.keycloakConfiguration.getKeycloakIssuerUrl() + ": HTTP status code " + response.getStatusCodeValue());
            }
            JsonObject json = JsonUtil.parseAsJsonObject((String)response.getBody());
            String accessToken = JsonUtil.getJsonString(json, "access_token");
            String tokenType = JsonUtil.getJsonString(json, "token_type");
            String refreshToken = JsonUtil.getJsonString(json, "refresh_token");
            long expiresInMillis = JsonUtil.getJsonLong(json, "expires_in") * 1000L;
            return new KeycloakContext(accessToken, tokenType, expiresInMillis, refreshToken, this.keycloakConfiguration.getCharset());
        }
        catch (RestClientException rce) {
            LOG.requestTokenFailed(rce);
            throw new IdentityProviderException("Unable to get access token from Keycloak server", (Throwable)rce);
        }
        catch (JsonException je) {
            LOG.requestTokenFailed(je);
            throw new IdentityProviderException("Unable to get access token from Keycloak server", (Throwable)je);
        }
    }

    private KeycloakContext refreshToken() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/x-www-form-urlencoded;charset=" + this.keycloakConfiguration.getCharset());
        HttpEntity<String> request = new HttpEntity<String>("client_id=" + this.keycloakConfiguration.getClientId() + "&client_secret=" + this.keycloakConfiguration.getClientSecret() + "&refresh_token=" + this.context.getRefreshToken() + "&grant_type=refresh_token", headers);
        try {
            ResponseEntity<String> response = this.restTemplate.postForEntity(this.keycloakConfiguration.getKeycloakIssuerUrl() + "/protocol/openid-connect/token", request, String.class, new Object[0]);
            if (!response.getStatusCode().equals((Object)HttpStatus.OK)) {
                throw new IdentityProviderException("Could not connect to " + this.keycloakConfiguration.getKeycloakIssuerUrl() + ": HTTP status code " + response.getStatusCodeValue());
            }
            JsonObject json = JsonUtil.parseAsJsonObject((String)response.getBody());
            String accessToken = JsonUtil.getJsonString(json, "access_token");
            String tokenType = JsonUtil.getJsonString(json, "token_type");
            String refreshToken = JsonUtil.getJsonString(json, "refresh_token");
            long expiresInMillis = JsonUtil.getJsonLong(json, "expires_in") * 1000L;
            return new KeycloakContext(accessToken, tokenType, expiresInMillis, refreshToken, this.keycloakConfiguration.getCharset());
        }
        catch (RestClientException rce) {
            LOG.refreshTokenFailed(rce);
            throw new IdentityProviderException("Unable to refresh access token from Keycloak server", (Throwable)rce);
        }
        catch (JsonException je) {
            LOG.refreshTokenFailed(je);
            throw new IdentityProviderException("Unable to refresh access token from Keycloak server", (Throwable)je);
        }
    }

    public HttpEntity<String> createApiRequestEntity() {
        if (this.context == null) {
            this.context = this.openAuthorizationContext();
        } else if (this.context.needsRefresh()) {
            try {
                this.context = this.refreshToken();
            }
            catch (IdentityProviderException ipe) {
                this.context = this.openAuthorizationContext();
            }
        }
        return this.context.createHttpRequestEntity();
    }
}

