/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import keycloakjar.com.google.gson.JsonArray;
import keycloakjar.com.google.gson.JsonObject;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.http.ResponseEntity;
import keycloakjar.org.springframework.util.MultiValueMap;
import keycloakjar.org.springframework.util.StringUtils;
import keycloakjar.org.springframework.web.client.HttpClientErrorException;
import keycloakjar.org.springframework.web.client.RestClientException;
import keycloakjar.org.springframework.web.client.RestTemplate;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.Direction;
import org.camunda.bpm.engine.impl.QueryOrderingProperty;
import org.camunda.bpm.engine.impl.UserQueryProperty;
import org.camunda.bpm.engine.impl.identity.IdentityProviderException;
import org.camunda.bpm.engine.impl.persistence.entity.UserEntity;
import org.camunda.bpm.extension.keycloak.KeycloakConfiguration;
import org.camunda.bpm.extension.keycloak.KeycloakContextProvider;
import org.camunda.bpm.extension.keycloak.KeycloakGroupNotFoundException;
import org.camunda.bpm.extension.keycloak.KeycloakServiceBase;
import org.camunda.bpm.extension.keycloak.KeycloakUserNotFoundException;
import org.camunda.bpm.extension.keycloak.KeycloakUserQuery;
import org.camunda.bpm.extension.keycloak.json.JsonException;
import org.camunda.bpm.extension.keycloak.json.JsonUtil;
import org.camunda.bpm.extension.keycloak.util.KeycloakPluginLogger;

public class KeycloakUserService
extends KeycloakServiceBase {
    public KeycloakUserService(KeycloakConfiguration keycloakConfiguration, RestTemplate restTemplate, KeycloakContextProvider keycloakContextProvider) {
        super(keycloakConfiguration, restTemplate, keycloakContextProvider);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getKeycloakAdminUserId(String configuredAdminUserId) {
        try {
            ResponseEntity<String> response2222 = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/users/" + configuredAdminUserId, HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
            if (this.keycloakConfiguration.isUseEmailAsCamundaUserId()) {
                return JsonUtil.parseAsJsonObjectAndGetMemberAsString((String)response2222.getBody(), "email");
            }
            if (!this.keycloakConfiguration.isUseUsernameAsCamundaUserId()) return JsonUtil.parseAsJsonObjectAndGetMemberAsString((String)response2222.getBody(), "id");
            return JsonUtil.parseAsJsonObjectAndGetMemberAsString((String)response2222.getBody(), "username");
        }
        catch (RestClientException | JsonException response2222) {
            try {
                if (this.keycloakConfiguration.isUseEmailAsCamundaUserId() && configuredAdminUserId.contains("@")) {
                    try {
                        this.getKeycloakUserID(configuredAdminUserId);
                        return configuredAdminUserId;
                    }
                    catch (KeycloakUserNotFoundException response2222) {
                        // empty catch block
                    }
                }
                try {
                    ResponseEntity<String> response3 = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/users?username=" + configuredAdminUserId, HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
                    JsonObject user = JsonUtil.findFirst(JsonUtil.parseAsJsonArray((String)response3.getBody()), "username", configuredAdminUserId);
                    if (user == null) throw new IdentityProviderException("Configured administratorUserId " + configuredAdminUserId + " does not exist.");
                    if (this.keycloakConfiguration.isUseEmailAsCamundaUserId()) {
                        return JsonUtil.getJsonString(user, "email");
                    }
                    if (!this.keycloakConfiguration.isUseUsernameAsCamundaUserId()) return JsonUtil.getJsonString(user, "id");
                    return JsonUtil.getJsonString(user, "username");
                }
                catch (JsonException response3) {
                    // empty catch block
                }
                throw new IdentityProviderException("Configured administratorUserId " + configuredAdminUserId + " does not exist.");
            }
            catch (RestClientException rce) {
                throw new IdentityProviderException("Unable to read data of configured administratorUserId " + configuredAdminUserId, (Throwable)rce);
            }
        }
    }

    public List<User> requestUsersByGroupId(KeycloakUserQuery query) {
        String groupId = query.getGroupId();
        List<Object> userList = new ArrayList<User>();
        StringBuilder resultLogger = new StringBuilder();
        if (KeycloakPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("Keycloak user query results: [");
        }
        try {
            String keyCloakID;
            try {
                keyCloakID = this.getKeycloakGroupID(groupId);
            }
            catch (KeycloakGroupNotFoundException e) {
                return userList;
            }
            ResponseEntity<String> response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/groups/" + keyCloakID + "/members?max=" + this.getMaxQueryResultSize(), HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
            if (!response.getStatusCode().equals((Object)HttpStatus.OK)) {
                throw new IdentityProviderException("Unable to read group members from " + this.keycloakConfiguration.getKeycloakAdminUrl() + ": HTTP status code " + response.getStatusCodeValue());
            }
            JsonArray searchResult = JsonUtil.parseAsJsonArray((String)response.getBody());
            for (int i = 0; i < searchResult.size(); ++i) {
                JsonObject keycloakUser = JsonUtil.getJsonObjectAtIndex(searchResult, i);
                if (this.keycloakConfiguration.isUseEmailAsCamundaUserId() && StringUtils.isEmpty(JsonUtil.getJsonString(keycloakUser, "email")) || this.keycloakConfiguration.isUseUsernameAsCamundaUserId() && StringUtils.isEmpty(JsonUtil.getJsonString(keycloakUser, "username"))) continue;
                UserEntity user = this.transformUser(keycloakUser);
                if (!this.matches(query.getId(), (Object)user.getId()) || !this.matches(query.getIds(), (Object)user.getId()) || !this.matches(query.getEmail(), (Object)user.getEmail()) || !this.matchesLike(query.getEmailLike(), user.getEmail()) || !this.matches(query.getFirstName(), (Object)user.getFirstName()) || !this.matchesLike(query.getFirstNameLike(), user.getFirstName()) || !this.matches(query.getLastName(), (Object)user.getLastName()) || !this.matchesLike(query.getLastNameLike(), user.getLastName()) || !this.isAuthenticatedUser(user) && !this.isAuthorized((Permission)Permissions.READ, (Resource)Resources.USER, user.getId())) continue;
                userList.add((User)user);
                if (!KeycloakPluginLogger.INSTANCE.isDebugEnabled()) continue;
                resultLogger.append(user);
                resultLogger.append(" based on ");
                resultLogger.append(keycloakUser.toString());
                resultLogger.append(", ");
            }
        }
        catch (HttpClientErrorException hcee) {
            if (hcee.getStatusCode().equals((Object)HttpStatus.NOT_FOUND)) {
                return userList;
            }
            throw hcee;
        }
        catch (RestClientException rce) {
            throw new IdentityProviderException("Unable to query members of group " + groupId, (Throwable)rce);
        }
        catch (JsonException je) {
            throw new IdentityProviderException("Unable to query members of group " + groupId, (Throwable)je);
        }
        if (KeycloakPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("]");
            KeycloakPluginLogger.INSTANCE.userQueryResult(resultLogger.toString());
        }
        if (query.getOrderingProperties().size() > 0) {
            userList.sort(new UserComparator(query.getOrderingProperties()));
        }
        if (query.getFirstResult() > 0 || query.getMaxResults() < Integer.MAX_VALUE) {
            userList = userList.subList(query.getFirstResult(), Math.min(userList.size(), query.getFirstResult() + query.getMaxResults()));
        }
        return userList;
    }

    public List<User> requestUsersWithoutGroupId(KeycloakUserQuery query) {
        List<Object> userList = new ArrayList<User>();
        StringBuilder resultLogger = new StringBuilder();
        if (KeycloakPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("Keycloak user query results: [");
        }
        try {
            ResponseEntity<String> response = null;
            if (!StringUtils.isEmpty(query.getId())) {
                response = this.requestUserById(query.getId());
            } else {
                String userFilter = this.createUserSearchFilter(query);
                response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/users" + userFilter, HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
            }
            if (!response.getStatusCode().equals((Object)HttpStatus.OK)) {
                throw new IdentityProviderException("Unable to read users from " + this.keycloakConfiguration.getKeycloakAdminUrl() + ": HTTP status code " + response.getStatusCodeValue());
            }
            JsonArray searchResult = JsonUtil.parseAsJsonArray((String)response.getBody());
            for (int i = 0; i < searchResult.size(); ++i) {
                JsonObject keycloakUser = JsonUtil.getJsonObjectAtIndex(searchResult, i);
                if (this.keycloakConfiguration.isUseEmailAsCamundaUserId() && StringUtils.isEmpty(JsonUtil.getJsonString(keycloakUser, "email")) || this.keycloakConfiguration.isUseUsernameAsCamundaUserId() && StringUtils.isEmpty(JsonUtil.getJsonString(keycloakUser, "username"))) continue;
                UserEntity user = this.transformUser(keycloakUser);
                if (!this.matches(query.getId(), (Object)user.getId()) || !this.matches(query.getEmail(), (Object)user.getEmail()) || !this.matches(query.getFirstName(), (Object)user.getFirstName()) || !this.matches(query.getLastName(), (Object)user.getLastName()) || !this.matches(query.getIds(), (Object)user.getId()) || !this.matchesLike(query.getEmailLike(), user.getEmail()) || !this.matchesLike(query.getFirstNameLike(), user.getFirstName()) || !this.matchesLike(query.getLastNameLike(), user.getLastName()) || !this.isAuthenticatedUser(user) && !this.isAuthorized((Permission)Permissions.READ, (Resource)Resources.USER, user.getId())) continue;
                userList.add((User)user);
                if (!KeycloakPluginLogger.INSTANCE.isDebugEnabled()) continue;
                resultLogger.append(user);
                resultLogger.append(" based on ");
                resultLogger.append(keycloakUser.toString());
                resultLogger.append(", ");
            }
        }
        catch (RestClientException rce) {
            throw new IdentityProviderException("Unable to query users", (Throwable)rce);
        }
        catch (JsonException je) {
            throw new IdentityProviderException("Unable to query users", (Throwable)je);
        }
        if (KeycloakPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("]");
            KeycloakPluginLogger.INSTANCE.userQueryResult(resultLogger.toString());
        }
        if (query.getOrderingProperties().size() > 0) {
            userList.sort(new UserComparator(query.getOrderingProperties()));
        }
        if (query.getFirstResult() > 0 || query.getMaxResults() < Integer.MAX_VALUE) {
            userList = userList.subList(query.getFirstResult(), Math.min(userList.size(), query.getFirstResult() + query.getMaxResults()));
        }
        return userList;
    }

    private String createUserSearchFilter(KeycloakUserQuery query) {
        StringBuilder filter = new StringBuilder();
        if (!StringUtils.isEmpty(query.getEmail())) {
            this.addArgument(filter, "email", query.getEmail());
        }
        if (!StringUtils.isEmpty(query.getEmailLike())) {
            this.addArgument(filter, "email", query.getEmailLike().replaceAll("[%,\\*]", ""));
        }
        if (!StringUtils.isEmpty(query.getFirstName())) {
            this.addArgument(filter, "firstName", query.getFirstName());
        }
        if (!StringUtils.isEmpty(query.getFirstNameLike())) {
            this.addArgument(filter, "firstName", query.getFirstNameLike().replaceAll("[%,\\*]", ""));
        }
        if (!StringUtils.isEmpty(query.getLastName())) {
            this.addArgument(filter, "lastName", query.getLastName());
        }
        if (!StringUtils.isEmpty(query.getLastNameLike())) {
            this.addArgument(filter, "lastName", query.getLastNameLike().replaceAll("[%,\\*]", ""));
        }
        this.addArgument(filter, "max", this.getMaxQueryResultSize());
        if (filter.length() > 0) {
            filter.insert(0, "?");
            String result = filter.toString();
            KeycloakPluginLogger.INSTANCE.userQueryFilter(result);
            return result;
        }
        return "";
    }

    private ResponseEntity<String> requestUserById(String userId) throws RestClientException {
        try {
            String userSearch = this.keycloakConfiguration.isUseEmailAsCamundaUserId() ? "/users?email=" + userId : (this.keycloakConfiguration.isUseUsernameAsCamundaUserId() ? "/users?username=" + userId : "/users/" + userId);
            ResponseEntity<String> response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + userSearch, HttpMethod.GET, this.keycloakContextProvider.createApiRequestEntity(), String.class, new Object[0]);
            String result = this.keycloakConfiguration.isUseEmailAsCamundaUserId() || this.keycloakConfiguration.isUseUsernameAsCamundaUserId() ? (String)response.getBody() : "[" + (String)response.getBody() + "]";
            return new ResponseEntity<String>(result, (MultiValueMap<String, String>)response.getHeaders(), response.getStatusCode());
        }
        catch (HttpClientErrorException hcee) {
            if (hcee.getStatusCode().equals((Object)HttpStatus.NOT_FOUND)) {
                String result = "[]";
                return new ResponseEntity<String>(result, HttpStatus.OK);
            }
            throw hcee;
        }
    }

    private UserEntity transformUser(JsonObject result) throws JsonException {
        UserEntity user = new UserEntity();
        if (this.keycloakConfiguration.isUseEmailAsCamundaUserId()) {
            user.setId(JsonUtil.getJsonString(result, "email"));
        } else if (this.keycloakConfiguration.isUseUsernameAsCamundaUserId()) {
            user.setId(JsonUtil.getJsonString(result, "username"));
        } else {
            user.setId(JsonUtil.getJsonString(result, "id"));
        }
        user.setFirstName(JsonUtil.getJsonString(result, "firstName"));
        user.setLastName(JsonUtil.getJsonString(result, "lastName"));
        if (StringUtils.isEmpty(user.getFirstName()) && StringUtils.isEmpty(user.getLastName())) {
            user.setFirstName(JsonUtil.getJsonString(result, "username"));
        }
        user.setEmail(JsonUtil.getJsonString(result, "email"));
        return user;
    }

    private static class UserComparator
    implements Comparator<User> {
        private static final int USER_ID = 0;
        private static final int EMAIL = 1;
        private static final int FIRST_NAME = 2;
        private static final int LAST_NAME = 3;
        private int[] order;
        private boolean[] desc;

        public UserComparator(List<QueryOrderingProperty> orderList) {
            this.order = new int[orderList.size()];
            this.desc = new boolean[orderList.size()];
            for (int i = 0; i < orderList.size(); ++i) {
                QueryOrderingProperty qop = orderList.get(i);
                this.order[i] = qop.getQueryProperty().equals(UserQueryProperty.USER_ID) ? 0 : (qop.getQueryProperty().equals(UserQueryProperty.EMAIL) ? 1 : (qop.getQueryProperty().equals(UserQueryProperty.FIRST_NAME) ? 2 : (qop.getQueryProperty().equals(UserQueryProperty.LAST_NAME) ? 3 : -1)));
                this.desc[i] = Direction.DESCENDING.equals(qop.getDirection());
            }
        }

        @Override
        public int compare(User u1, User u2) {
            int c = 0;
            for (int i = 0; i < this.order.length; ++i) {
                switch (this.order[i]) {
                    case 0: {
                        c = KeycloakServiceBase.compare(u1.getId(), u2.getId());
                        break;
                    }
                    case 1: {
                        c = KeycloakServiceBase.compare(u1.getEmail(), u2.getEmail());
                        break;
                    }
                    case 2: {
                        c = KeycloakServiceBase.compare(u1.getFirstName(), u2.getFirstName());
                        break;
                    }
                    case 3: {
                        c = KeycloakServiceBase.compare(u1.getLastName(), u2.getLastName());
                        break;
                    }
                }
                if (c == 0) continue;
                return this.desc[i] ? -c : c;
            }
            return c;
        }
    }
}

