/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.client.reactive;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import keycloakjar.org.apache.hc.client5.http.cookie.Cookie;
import keycloakjar.org.apache.hc.client5.http.protocol.HttpClientContext;
import keycloakjar.org.apache.hc.core5.http.HttpResponse;
import keycloakjar.org.apache.hc.core5.http.Message;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferFactory;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.http.ResponseCookie;
import keycloakjar.org.springframework.http.client.reactive.ClientHttpResponse;
import keycloakjar.org.springframework.http.client.reactive.HttpComponentsHeadersAdapter;
import keycloakjar.org.springframework.util.LinkedMultiValueMap;
import keycloakjar.org.springframework.util.MultiValueMap;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

class HttpComponentsClientHttpResponse
implements ClientHttpResponse {
    private final DataBufferFactory dataBufferFactory;
    private final Message<HttpResponse, Publisher<ByteBuffer>> message;
    private final HttpHeaders headers;
    private final HttpClientContext context;
    private final AtomicBoolean rejectSubscribers = new AtomicBoolean();

    public HttpComponentsClientHttpResponse(DataBufferFactory dataBufferFactory, Message<HttpResponse, Publisher<ByteBuffer>> message, HttpClientContext context) {
        this.dataBufferFactory = dataBufferFactory;
        this.message = message;
        this.context = context;
        HttpComponentsHeadersAdapter adapter = new HttpComponentsHeadersAdapter((HttpResponse)message.getHead());
        this.headers = HttpHeaders.readOnlyHttpHeaders(adapter);
    }

    @Override
    public HttpStatus getStatusCode() {
        return HttpStatus.valueOf(((HttpResponse)this.message.getHead()).getCode());
    }

    @Override
    public int getRawStatusCode() {
        return ((HttpResponse)this.message.getHead()).getCode();
    }

    @Override
    public MultiValueMap<String, ResponseCookie> getCookies() {
        LinkedMultiValueMap<String, ResponseCookie> result = new LinkedMultiValueMap<String, ResponseCookie>();
        this.context.getCookieStore().getCookies().forEach(cookie -> result.add(cookie.getName(), ResponseCookie.fromClientResponse(cookie.getName(), cookie.getValue()).domain(cookie.getDomain()).path(cookie.getPath()).maxAge(this.getMaxAgeSeconds((Cookie)cookie)).secure(cookie.isSecure()).httpOnly(cookie.containsAttribute("httponly")).sameSite(cookie.getAttribute("samesite")).build()));
        return result;
    }

    private long getMaxAgeSeconds(Cookie cookie) {
        String maxAgeAttribute = cookie.getAttribute("max-age");
        return maxAgeAttribute != null ? Long.parseLong(maxAgeAttribute) : -1L;
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return Flux.from((Publisher)((Publisher)this.message.getBody())).doOnSubscribe(s -> {
            if (!this.rejectSubscribers.compareAndSet(false, true)) {
                throw new IllegalStateException("The client response body can only be consumed once.");
            }
        }).map(this.dataBufferFactory::wrap);
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }
}

