/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import keycloakjar.org.springframework.http.HttpInputMessage;
import keycloakjar.org.springframework.http.HttpOutputMessage;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.converter.AbstractHttpMessageConverter;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.StreamUtils;

public class ByteArrayHttpMessageConverter
extends AbstractHttpMessageConverter<byte[]> {
    public ByteArrayHttpMessageConverter() {
        super(MediaType.APPLICATION_OCTET_STREAM, MediaType.ALL);
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return byte[].class == clazz;
    }

    @Override
    public byte[] readInternal(Class<? extends byte[]> clazz, HttpInputMessage inputMessage) throws IOException {
        long contentLength = inputMessage.getHeaders().getContentLength();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(contentLength >= 0L ? (int)contentLength : 4096);
        StreamUtils.copy(inputMessage.getBody(), (OutputStream)bos);
        return bos.toByteArray();
    }

    @Override
    protected Long getContentLength(byte[] bytes, @Nullable MediaType contentType) {
        return bytes.length;
    }

    @Override
    protected void writeInternal(byte[] bytes, HttpOutputMessage outputMessage) throws IOException {
        StreamUtils.copy(bytes, outputMessage.getBody());
    }
}

