/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import keycloakjar.org.springframework.core.annotation.AnnotationAwareOrderComparator;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.ReflectionUtils;
import keycloakjar.org.springframework.web.WebApplicationInitializer;

@HandlesTypes(value={WebApplicationInitializer.class})
public class SpringServletContainerInitializer
implements ServletContainerInitializer {
    public void onStartup(@Nullable Set<Class<?>> webAppInitializerClasses, ServletContext servletContext) throws ServletException {
        List<WebApplicationInitializer> initializers = Collections.emptyList();
        if (webAppInitializerClasses != null) {
            initializers = new ArrayList<WebApplicationInitializer>(webAppInitializerClasses.size());
            for (Class<?> waiClass : webAppInitializerClasses) {
                if (waiClass.isInterface() || Modifier.isAbstract(waiClass.getModifiers()) || !WebApplicationInitializer.class.isAssignableFrom(waiClass)) continue;
                try {
                    initializers.add((WebApplicationInitializer)ReflectionUtils.accessibleConstructor(waiClass, new Class[0]).newInstance(new Object[0]));
                }
                catch (Throwable ex) {
                    throw new ServletException("Failed to instantiate WebApplicationInitializer class", ex);
                }
            }
        }
        if (initializers.isEmpty()) {
            servletContext.log("No Spring WebApplicationInitializer types detected on classpath");
            return;
        }
        servletContext.log(initializers.size() + " Spring WebApplicationInitializers detected on classpath");
        AnnotationAwareOrderComparator.sort(initializers);
        for (WebApplicationInitializer initializer : initializers) {
            initializer.onStartup(servletContext);
        }
    }
}

