/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.bind.support;

import javax.servlet.http.HttpServletRequest;
import keycloakjar.org.springframework.beans.MutablePropertyValues;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.StringUtils;
import keycloakjar.org.springframework.validation.BindException;
import keycloakjar.org.springframework.web.bind.WebDataBinder;
import keycloakjar.org.springframework.web.context.request.NativeWebRequest;
import keycloakjar.org.springframework.web.context.request.WebRequest;
import keycloakjar.org.springframework.web.multipart.MultipartRequest;
import keycloakjar.org.springframework.web.multipart.support.StandardServletPartUtils;

public class WebRequestDataBinder
extends WebDataBinder {
    public WebRequestDataBinder(@Nullable Object target) {
        super(target);
    }

    public WebRequestDataBinder(@Nullable Object target, String objectName) {
        super(target, objectName);
    }

    public void bind(WebRequest request) {
        MutablePropertyValues mpvs = new MutablePropertyValues(request.getParameterMap());
        if (request instanceof NativeWebRequest) {
            HttpServletRequest servletRequest;
            MultipartRequest multipartRequest = ((NativeWebRequest)request).getNativeRequest(MultipartRequest.class);
            if (multipartRequest != null) {
                this.bindMultipart(multipartRequest.getMultiFileMap(), mpvs);
            } else if (StringUtils.startsWithIgnoreCase(request.getHeader("Content-Type"), "multipart/") && (servletRequest = ((NativeWebRequest)request).getNativeRequest(HttpServletRequest.class)) != null) {
                StandardServletPartUtils.bindParts(servletRequest, mpvs, this.isBindEmptyMultipartFiles());
            }
        }
        this.doBind(mpvs);
    }

    public void closeNoCatch() throws BindException {
        if (this.getBindingResult().hasErrors()) {
            throw new BindException(this.getBindingResult());
        }
    }
}

