/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.multipart.support;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import keycloakjar.org.apache.commons.logging.LogFactory;
import keycloakjar.org.springframework.util.StringUtils;
import keycloakjar.org.springframework.web.multipart.MultipartException;
import keycloakjar.org.springframework.web.multipart.MultipartHttpServletRequest;
import keycloakjar.org.springframework.web.multipart.MultipartResolver;
import keycloakjar.org.springframework.web.multipart.support.AbstractMultipartHttpServletRequest;
import keycloakjar.org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;

public class StandardServletMultipartResolver
implements MultipartResolver {
    private boolean resolveLazily = false;

    public void setResolveLazily(boolean resolveLazily) {
        this.resolveLazily = resolveLazily;
    }

    @Override
    public boolean isMultipart(HttpServletRequest request) {
        return StringUtils.startsWithIgnoreCase(request.getContentType(), "multipart/");
    }

    @Override
    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        return new StandardMultipartHttpServletRequest(request, this.resolveLazily);
    }

    @Override
    public void cleanupMultipart(MultipartHttpServletRequest request) {
        if (!(request instanceof AbstractMultipartHttpServletRequest) || ((AbstractMultipartHttpServletRequest)request).isResolved()) {
            try {
                for (Part part : request.getParts()) {
                    if (request.getFile(part.getName()) == null) continue;
                    part.delete();
                }
            }
            catch (Throwable ex) {
                LogFactory.getLog(this.getClass()).warn("Failed to perform cleanup of multipart items", ex);
            }
        }
    }
}

